/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.util.ArrayList;
import java.util.LinkedList;

public class Worker
implements Runnable {
    private LinkedList queue = new LinkedList();
    private ArrayList threads;
    private volatile boolean RUN = true;
    private Runnable _lastRunnable = null;
    private int maxThreads = 1;
    private int waitingThreads;
    private String thrNamePrefix = "com.sun.im.service.util.Worker";
    private int _capacity = -1;

    public Worker() {
        this.init(this.maxThreads, this.maxThreads, -1, null);
    }

    public Worker(int threadCnt) {
        this.init(threadCnt, threadCnt, -1, null);
    }

    public Worker(int minThreads, int maxThreads) {
        this.init(minThreads, maxThreads, -1, null);
    }

    public Worker(int minThreads, int maxThreads, int capacity) {
        this.init(minThreads, maxThreads, capacity, null);
    }

    public Worker(int minThreads, int maxThreads, String thrNamePrefix) {
        this.init(minThreads, maxThreads, -1, thrNamePrefix);
    }

    private void init(int minThreads, int maxThreads, int capacity, String thrNamePrefix) {
        this._capacity = capacity;
        this.maxThreads = maxThreads < minThreads ? minThreads : maxThreads;
        if (thrNamePrefix != null) {
            this.thrNamePrefix = thrNamePrefix;
        }
        this.threads = new ArrayList(maxThreads);
        for (int i = 0; i < minThreads; ++i) {
            Thread t = new Thread((Runnable)this, this.thrNamePrefix + " " + i);
            this.threads.add(t);
            t.start();
        }
    }

    public synchronized int addRunnable(Runnable r) {
        if (!this.RUN) {
            return this.queue.size();
        }
        this.queue.addLast(r);
        if (this.waitingThreads > 0) {
            this.notify();
        }
        if (this.threads.size() < this.maxThreads && this.waitingThreads < this.queue.size()) {
            Thread t = new Thread((Runnable)this, this.thrNamePrefix + " " + this.threads.size());
            this.threads.add(t);
            t.start();
        }
        return this.queue.size();
    }

    public synchronized int addRunnableIfPossible(Runnable r) {
        if (!this.RUN) {
            return this.queue.size();
        }
        if (this._capacity > this.maxThreads && this.queue.size() >= this._capacity) {
            Thread.yield();
            return -1;
        }
        return this.addRunnable(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.RUN) {
            Runnable r = null;
            Worker worker = this;
            synchronized (worker) {
                while (this.queue.size() == 0) {
                    try {
                        ++this.waitingThreads;
                        this.wait();
                        --this.waitingThreads;
                        if (this.RUN) continue;
                        return;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                r = (Runnable)this.queue.removeFirst();
                if (this._lastRunnable == r) {
                    this.RUN = false;
                }
            }
            try {
                if (r == null) continue;
                r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.RUN = false;
        Worker worker = this;
        synchronized (worker) {
            this.notifyAll();
        }
    }

    public final void stop(Runnable r) {
        this._lastRunnable = r;
        this.addRunnable(this._lastRunnable);
    }

    ArrayList getThreads() {
        return this.threads;
    }
}

