/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.HostPort;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class Socks5SocketChannelAdaptor {
    static final byte PROTO_VERS4 = 4;
    static final byte PROTO_VERS = 5;
    static final int DEFAULT_PORT = 1080;
    static final byte NO_AUTH = 0;
    static final byte GSSAPI = 1;
    static final byte USER_PASSW = 2;
    static final short NO_METHODS = 255;
    static final byte CONNECT = 1;
    static final byte BIND = 2;
    static final byte UDP_ASSOC = 3;
    static final byte IPV4 = 1;
    static final byte DOMAIN_NAME = 3;
    static final byte IPV6 = 4;
    static final byte REQUEST_OK = 0;
    static final byte GENERAL_FAILURE = 1;
    static final byte NOT_ALLOWED = 2;
    static final byte NET_UNREACHABLE = 3;
    static final byte HOST_UNREACHABLE = 4;
    static final byte CONN_REFUSED = 5;
    static final byte TTL_EXPIRED = 6;
    static final byte CMD_NOT_SUPPORTED = 7;
    static final byte ADDR_TYPE_NOT_SUP = 8;
    private InetSocketAddress socksProxyAddress;
    private InetSocketAddress destinationAddress;
    private String username;
    private String password;
    private SocketChannel _channel = null;

    public static SocketChannel open(String host, int port, String socksHost, int socksPort, String username, String password) throws UnknownHostException, IOException {
        InetSocketAddress isa = new InetSocketAddress(socksHost, socksPort <= 0 ? 1080 : socksPort);
        Socks5SocketChannelAdaptor ssca = new Socks5SocketChannelAdaptor(host, port, (SocketAddress)isa, username, password);
        return ssca.getChannel();
    }

    public static SocketChannel open(InetAddress address, int port, InetAddress socksAddress, int socksPort, String username, String password) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(socksAddress, socksPort <= 0 ? 1080 : socksPort);
        Socks5SocketChannelAdaptor ssca = new Socks5SocketChannelAdaptor(address, port, (SocketAddress)isa, username, password);
        return ssca.getChannel();
    }

    private Socks5SocketChannelAdaptor() throws IOException {
        this._channel = SocketChannel.open();
    }

    private Socks5SocketChannelAdaptor(SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open();
        this.setProxyAddress(sa);
        this.setUsername(username);
        this.setPassword(password);
    }

    private Socks5SocketChannelAdaptor(String host, int port, SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(host, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private Socks5SocketChannelAdaptor(InetAddress address, int port, SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(address, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private Socks5SocketChannelAdaptor(String host, int port, InetAddress localAddr, int localPort, SocketAddress sa, String username, String password) throws UnknownHostException, IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(host, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private Socks5SocketChannelAdaptor(InetAddress address, int port, InetAddress localAddr, int localPort, SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(address, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private Socks5SocketChannelAdaptor(String host, int port, boolean stream, SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(host, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private Socks5SocketChannelAdaptor(InetAddress address, int port, boolean stream, SocketAddress sa, String username, String password) throws IOException {
        this._channel = SocketChannel.open(sa);
        this.setDestinationAddress(address, port);
        this.setUsername(username);
        this.setPassword(password);
        this.finishConnect();
    }

    private boolean isClosed() {
        return !this._channel.isOpen();
    }

    private InetAddress getInetAddress() {
        if (this._channel.socket().getInetAddress() != null && this.getDestinationAddress() != null) {
            return this.getDestinationAddress().getAddress();
        }
        return null;
    }

    private int getPort() {
        int result = this._channel.socket().getPort();
        if (result > 0) {
            result = this.getDestinationAddress() == null ? -1 : this.getDestinationAddress().getPort();
        }
        return result;
    }

    public String toString() {
        if (this._channel.isConnected()) {
            return this._channel.socket().toString() + " SOCKS[socksAddr=" + null + ", socksPort=" + null + "]";
        }
        return "Socket[unconnected]";
    }

    private InetSocketAddress getProxyAddress() {
        return this.socksProxyAddress;
    }

    private void setProxyAddress(String host, int port) throws UnknownHostException, IOException {
        if (this._channel.isConnected() || this.isClosed()) {
            throw new IllegalStateException("Socket is currently connected or has been closed");
        }
        if (null == host || host.trim().length() == 0) {
            throw new IllegalArgumentException("parameter 'host' may not be null or blank");
        }
        this.setProxyAddress(InetAddress.getByName(host), port <= 0 ? 1080 : port);
    }

    private void setProxyAddress(InetAddress address, int port) throws IOException {
        if (this._channel.isConnected() || this.isClosed()) {
            throw new IllegalStateException("Socket is currently connected or has been closed");
        }
        if (null == address) {
            throw new IllegalArgumentException("parameter 'address' may not be null");
        }
        this.socksProxyAddress = new InetSocketAddress(address, port <= 0 ? 1080 : port);
    }

    private void setProxyAddress(InetSocketAddress address) throws IOException {
        if (this._channel.isConnected() || this.isClosed()) {
            throw new IllegalStateException("Socket is currently connected or has been closed");
        }
        if (null == address) {
            throw new IllegalArgumentException("parameter 'address' may not be null");
        }
        this.socksProxyAddress = address;
    }

    private void setProxyAddress(SocketAddress address) throws IOException {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("parameter 'address' must be an InetSocketAddress");
        }
        this.setProxyAddress((InetSocketAddress)address);
    }

    private InetSocketAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    private void setDestinationAddress(String host, int port) throws UnknownHostException, IOException {
        if (null == host || host.trim().length() == 0) {
            throw new IllegalArgumentException("parameter 'host' may not be null or blank");
        }
        this.setDestinationAddress(new InetSocketAddress(host, port <= 0 ? 1080 : port));
    }

    private void setDestinationAddress(InetAddress address, int port) throws IOException {
        if (null == address) {
            throw new IllegalArgumentException("parameter 'address' may not be null");
        }
        this.destinationAddress = new InetSocketAddress(address, port <= 0 ? 1080 : port);
    }

    private void setDestinationAddress(InetSocketAddress address) {
        if (null == address) {
            throw new IllegalArgumentException("parameter 'address' may not be null");
        }
        this.destinationAddress = address;
    }

    private String getUsername() {
        return this.username;
    }

    private void setUsername(String username) {
        this.username = username;
    }

    private String getPassword() {
        return this.password;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    private int readSocksReply(InputStream in, byte[] data) throws IOException {
        int count;
        int len = data.length;
        int received = 0;
        for (int attempts = 0; received < len && attempts < 3; received += count, ++attempts) {
            count = in.read(data, received, len - received);
            if (count >= 0) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return received;
    }

    private boolean authenticate(byte method, InputStream in, DataOutputStream out) throws IOException {
        if (method == 0) {
            return true;
        }
        if (method == 2) {
            if (this.getUsername() == null) {
                return false;
            }
            out.write(1);
            out.write((byte)this.getUsername().length());
            out.write(this.getUsername().getBytes());
            if (this.getPassword() != null) {
                out.write((byte)this.getPassword().length());
                out.write(this.getPassword().getBytes());
            } else {
                out.write(0);
            }
            out.flush();
            byte[] data = new byte[2];
            int i = this.readSocksReply(in, data);
            if (i != 2 || data[1] != 0) {
                out.close();
                this._channel.close();
                return false;
            }
            return true;
        }
        return false;
    }

    private void finishConnect() throws IOException {
        DataOutputStream out = new DataOutputStream(this._channel.socket().getOutputStream());
        InputStream in = this._channel.socket().getInputStream();
        out.write(5);
        out.write(2);
        out.write(0);
        out.write(2);
        out.flush();
        byte[] data = new byte[2];
        int i = this.readSocksReply(in, data);
        if (i != 2 || data[1] == 255) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(data[1], in, out)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        out.write(5);
        out.write(1);
        out.write(0);
        InetSocketAddress epoint = this.getDestinationAddress();
        if (epoint.isUnresolved()) {
            out.write(3);
            out.write(epoint.getHostName().length());
            out.write(epoint.getHostName().getBytes());
            out.write((byte)(epoint.getPort() >> 8 & 0xFF));
            out.write((byte)(epoint.getPort() >> 0 & 0xFF));
        } else if (epoint.getAddress() instanceof Inet6Address) {
            out.write(4);
            out.write(epoint.getAddress().getAddress());
            out.write((byte)(epoint.getPort() >> 8 & 0xFF));
            out.write((byte)(epoint.getPort() >> 0 & 0xFF));
        } else {
            out.write(1);
            out.write(epoint.getAddress().getAddress());
            out.write((byte)(epoint.getPort() >> 8 & 0xFF));
            out.write((byte)(epoint.getPort() >> 0 & 0xFF));
        }
        out.flush();
        data = new byte[4];
        i = this.readSocksReply(in, data);
        if (i != 4) {
            throw new SocketException("Reply from SOCKS server has bad length");
        }
        SocketException ex = null;
        block0 : switch (data[1]) {
            case 0: {
                switch (data[3]) {
                    case 1: {
                        byte[] addr = new byte[4];
                        i = this.readSocksReply(in, addr);
                        if (i != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        nport += data[1] & 0xFF;
                        break block0;
                    }
                    case 3: {
                        byte len = data[1];
                        byte[] host = new byte[len];
                        i = this.readSocksReply(in, host);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        nport += data[1] & 0xFF;
                        break block0;
                    }
                    case 4: {
                        byte len = data[1];
                        byte[] addr = new byte[len];
                        i = this.readSocksReply(in, addr);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        nport += data[1] & 0xFF;
                        break block0;
                    }
                }
                ex = new SocketException("Reply from SOCKS server contains wrong code");
                break;
            }
            case 1: {
                ex = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                ex = new SocketException("SOCKS: Connection not allowed by ruleset");
                break;
            }
            case 3: {
                ex = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                ex = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                ex = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                ex = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                ex = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                ex = new SocketException("SOCKS: address type not supported");
            }
        }
        if (ex != null) {
            out.close();
            this._channel.close();
            throw ex;
        }
    }

    public static void main(String[] args) {
        String HTTP_GET = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>\r\n";
        String sHostPort = "localhost";
        String sProxyHostPort = "localhost";
        String user = "foo";
        String password = "bar";
        if (args.length >= 1) {
            sHostPort = args[0];
        }
        if (args.length >= 2) {
            sProxyHostPort = args[1];
        }
        if (args.length == 4) {
            user = args[2];
            password = args[3];
        }
        try {
            int len;
            HostPort server = new HostPort(sHostPort, 80);
            HostPort proxy = new HostPort(sProxyHostPort, 1080);
            SocketChannel sc = Socks5SocketChannelAdaptor.open(server.getHostName(), server.getPort(), proxy.getHostName(), proxy.getPort(), user, password);
            System.out.println("Sending -> <stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>\r\n");
            ByteBuffer bb = ByteBuffer.wrap("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>\r\n".getBytes("US-ASCII"));
            sc.write(bb);
            System.out.println("Receiving <-");
            bb = ByteBuffer.allocate(1024);
            byte[] b = new byte[1024];
            do {
                bb.rewind();
                len = sc.read(bb);
                System.out.println("Receiving <- " + len);
                if (len <= 0) continue;
                bb.flip();
                bb.get(b, 0, len);
                System.out.print(new String(b, 0, len));
            } while (len >= 0);
            sc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

