/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.BufferedByteChannel;
import com.sun.im.service.util.Worker;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectWorker
implements Runnable {
    HashSet registerList = new HashSet();
    HashSet interestList = new HashSet();
    HashSet cancelList = new HashSet();
    Selector mySelector;
    boolean stop = false;
    Worker _worker;
    PrintStream debugOut;

    public SelectWorker(int minThreads, int maxThreads) throws Exception {
        this(new Worker(minThreads, maxThreads, "SelectWorker"));
    }

    public SelectWorker(int minThreads, int maxThreads, PrintStream out) throws Exception {
        this(new Worker(minThreads, maxThreads, "SelectWorker"));
        this.debugOut = out;
    }

    public SelectWorker(Worker w) throws Exception {
        this._worker = w;
        this.mySelector = Selector.open();
    }

    public SelectWorker(Worker w, PrintStream out) throws Exception {
        this(w);
        this.debugOut = out;
    }

    public void close() {
        this.stop = true;
        try {
            this.mySelector.wakeup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            try {
                Iterator<Object> iter;
                int n = this.mySelector.select();
                if (this.stop) break;
                if (this.debugOut != null) {
                    this.debugOut.println("NIODEBUG: selected " + n);
                }
                Object object = this.cancelList;
                synchronized (object) {
                    iter = this.cancelList.iterator();
                    while (iter.hasNext()) {
                        Selection sel = (Selection)iter.next();
                        try {
                            sel.closeChannel();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.cancelList.clear();
                }
                object = this.registerList;
                synchronized (object) {
                    iter = this.registerList.iterator();
                    while (iter.hasNext()) {
                        ((Selection)iter.next()).register();
                    }
                    this.registerList.clear();
                }
                object = this;
                synchronized (object) {
                    iter = this.mySelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = (SelectionKey)iter.next();
                        iter.remove();
                        boolean readable = false;
                        boolean writable = false;
                        if (key.isValid()) {
                            if ((key.interestOps() & 1) != 0 && key.isReadable()) {
                                readable = true;
                            }
                            if ((key.interestOps() & 4) != 0 && key.isWritable()) {
                                writable = true;
                            }
                            Selection sel = (Selection)key.attachment();
                            if (this.debugOut != null) {
                                this.debugOut.println("Selected key readable=" + readable + " writable=" + writable + " channel=" + sel.getChannel());
                            }
                            if (writable) {
                                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                                this._worker.addRunnable(sel.writable);
                            }
                            if (!readable || sel.readable == null) continue;
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            if (this._worker.addRunnableIfPossible(sel.readable) >= 0) continue;
                            key.interestOps(key.interestOps() | 1);
                            continue;
                        }
                        if (this.debugOut == null) continue;
                        this.debugOut.println("invalid key selected");
                    }
                }
                object = this.interestList;
                synchronized (object) {
                    iter = this.interestList.iterator();
                    while (iter.hasNext()) {
                        ((Selection)iter.next()).resetInterest();
                    }
                    this.interestList.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.mySelector.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._worker.stop();
    }

    public Selection register(SelectableChannel channel, Runnable runnable) throws IOException {
        channel.configureBlocking(false);
        Selection selection = new Selection(channel, runnable);
        this.register(selection);
        return selection;
    }

    public Selection register(SelectableChannel channel, Runnable readable, BufferedByteChannel writable) throws IOException {
        channel.configureBlocking(false);
        Selection selection = new Selection(channel, readable, writable);
        writable.setSelectionKey(selection);
        this.register(selection);
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Selection selection) {
        HashSet hashSet = this.registerList;
        synchronized (hashSet) {
            if (!this.registerList.contains(selection)) {
                this.registerList.add(selection);
            }
        }
        this.mySelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Object o) {
        if (!(o instanceof Selection)) {
            return;
        }
        HashSet hashSet = this.registerList;
        synchronized (hashSet) {
            this.registerList.remove(o);
        }
        hashSet = this.interestList;
        synchronized (hashSet) {
            this.interestList.remove(o);
        }
        hashSet = this.cancelList;
        synchronized (hashSet) {
            if (!this.cancelList.contains(o)) {
                this.cancelList.add(o);
            }
        }
        this.mySelector.wakeup();
    }

    public void interestOps(Object o, int ops) {
        if (!(o instanceof Selection)) {
            return;
        }
        ((Selection)o).addInterestOps(ops);
    }

    private Selection getSelection(Object o) {
        if (o instanceof Selection) {
            return (Selection)o;
        }
        if (o instanceof SelectionKey) {
            Object sel = ((SelectionKey)o).attachment();
            if (!(sel instanceof Selection)) {
                return null;
            }
            return (Selection)sel;
        }
        throw new IllegalArgumentException("Unexpected argument class: " + (o != null ? o.getClass().toString() : "null"));
    }

    public SelectableChannel getChannel(Object o) {
        Selection sel = this.getSelection(o);
        if (sel != null) {
            return sel.getChannel();
        }
        return null;
    }

    public SelectionKey getSelectionKey(Object o) {
        if (o instanceof Selection) {
            return ((Selection)o).key;
        }
        if (o instanceof SelectionKey) {
            return (SelectionKey)o;
        }
        throw new IllegalArgumentException("Unexpected argument class: " + (o != null ? o.getClass().toString() : "null"));
    }

    public Object attachment(Object o) {
        Selection sel = this.getSelection(o);
        if (sel != null) {
            return sel.readRunnable;
        }
        return null;
    }

    public void print(PrintStream out, Object o) {
        Selection sel = this.getSelection(o);
        if (sel != null) {
            sel.print(out);
        } else {
            out.println("no attachment in selection key " + o);
        }
    }

    public Set keys() {
        return this.mySelector.keys();
    }

    public Selector getSelector() {
        return this.mySelector;
    }

    class Selection {
        SelectableChannel channel;
        SelectionKey key;
        Runnable readRunnable;
        BufferedByteChannel writer;
        int operations = 0;
        boolean reading = false;
        Runnable readable = new Runnable(this){
            private final /* synthetic */ Selection this$1;
            {
                this.this$1 = this$1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.this$1.channel.isOpen()) {
                    Selection selection = this.this$1;
                    synchronized (selection) {
                        this.this$1.reading = true;
                        this.this$1.operations &= 0xFFFE;
                    }
                    try {
                        this.this$1.readRunnable.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    selection = this.this$1;
                    synchronized (selection) {
                        this.this$1.reading = false;
                    }
                    this.this$1.addInterestOps(1);
                }
            }
        };
        Runnable writable = new Runnable(this){
            private final /* synthetic */ Selection this$1;
            {
                this.this$1 = this$1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.this$1.channel.isOpen()) {
                    Selection selection = this.this$1;
                    synchronized (selection) {
                        this.this$1.operations &= 0xFFFB;
                    }
                    try {
                        if (this.this$1.writer.writeNow() > 0) {
                            this.this$1.addInterestOps(4);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };

        Selection(SelectableChannel channel, Runnable runnable) {
            this.channel = channel;
            this.readRunnable = runnable;
        }

        Selection(SelectableChannel channel, Runnable readable, BufferedByteChannel writer) {
            this.channel = channel;
            this.readRunnable = readable;
            this.writer = writer;
        }

        Selection(SelectableChannel channel) {
            this.channel = channel;
        }

        void closeChannel() throws IOException {
            if (this.key != null) {
                this.key.cancel();
            }
            this.key = null;
            if (this.channel.isOpen()) {
                this.channel.close();
            }
            this.readable = null;
        }

        SelectableChannel getChannel() {
            return this.channel;
        }

        void register() throws ClosedChannelException {
            if (this.channel.isOpen()) {
                this.key = this.channel.register(SelectWorker.this.mySelector, 1, this);
                if (SelectWorker.this.debugOut != null) {
                    SelectWorker.this.debugOut.println("SelectWorker registered=" + this.channel);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetInterest() {
            if (!this.channel.isOpen()) {
                if (SelectWorker.this.debugOut != null) {
                    SelectWorker.this.debugOut.println("[SelectWorker] NOT resetting interest for closed " + this.channel);
                }
                return;
            }
            int ops = 0;
            Selection selection = this;
            synchronized (selection) {
                ops = this.operations;
                if (SelectWorker.this.debugOut != null) {
                    SelectWorker.this.debugOut.println("[SelectWorker] resetting interest to " + ops + " for " + this.channel);
                }
                if (ops == 0) {
                    return;
                }
                this.operations = 0;
            }
            if (this.key != null && this.key.isValid()) {
                this.key.interestOps(ops | this.key.interestOps());
                if (SelectWorker.this.debugOut != null) {
                    SelectWorker.this.debugOut.println("[SelectWorker] reset interest to " + ops + " for " + this.channel);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addInterestOps(int ops) {
            boolean interestAlreadyQueued = false;
            Object object = this;
            synchronized (object) {
                if (this.reading) {
                    ops &= 0xFFFE;
                }
                interestAlreadyQueued = this.operations != 0;
                this.operations |= ops;
            }
            if (!interestAlreadyQueued) {
                object = SelectWorker.this.interestList;
                synchronized (object) {
                    SelectWorker.this.interestList.add(this);
                }
            }
            SelectWorker.this.mySelector.wakeup();
        }

        void print(PrintStream out) {
            out.println("[SelectWorker] Selection channel=" + this.channel + " key=" + this.key + " readRunnable=" + this.readRunnable + " writer=" + this.writer + " operations=" + this.operations + " reading=" + this.reading);
        }
    }
}

