/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;

public final class PlatformUtil {
    private static boolean is95 = false;
    private static boolean is98 = false;
    private static boolean isNT = false;
    private static boolean is2000 = false;
    private static boolean isXP = false;
    private static boolean isos2 = false;
    private static boolean isunix = false;
    private static boolean isSun = false;
    private static boolean isLinux = false;
    private static boolean ismac = false;
    private static boolean is1_1 = false;
    private static boolean is1_2 = false;
    private static boolean is1_3 = false;
    private static boolean is1_4 = false;
    private static boolean is1_5 = false;
    private static boolean isJava2 = true;
    private static boolean isJview = false;
    public static boolean isJview40 = false;
    private static final String WIN95_ID = "windows 95";
    private static final String WIN98_ID = "windows 98";
    private static final String WINNT_ID = "windows nt";
    private static final String WIN2K_ID = "windows 2000";
    private static final String WINXP_ID = "windows xp";
    private static final String OS2_ID = "os/2";
    private static final String MAC_ID = "mac os";
    private static final String UNIX_ID = "unix";
    private static final String SUN_ID = "SunOS";
    private static final String LINUX_ID = "Linux";

    private static final String getMsVersion() {
        StringBuffer ret = new StringBuffer();
        try {
            Class<?> c = Class.forName("com.ms.util.SystemVersionManager");
            Method m = c.getDeclaredMethod("getVMVersion", null);
            Object o = null;
            Properties p = (Properties)m.invoke(o, new Object[0]);
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                ret.append("MS ");
                ret.append(key);
                ret.append(" :: ");
                String tmp = p.getProperty(key);
                if (tmp.indexOf("3240") >= 0) {
                    isJview40 = true;
                }
                ret.append(tmp);
                ret.append("\n");
            }
            e = null;
        }
        catch (Exception e) {
            System.out.println("getMsVersion:" + e);
        }
        return ret.toString();
    }

    public static final String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static final String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static final String getOSName() {
        return System.getProperty("os.name");
    }

    public static final String getNoSpaceOSName() {
        if (PlatformUtil.isWin()) {
            return "Windows";
        }
        if (PlatformUtil.isMac()) {
            return "MacOS";
        }
        return System.getProperty("os.name");
    }

    public static final String getOSArch() {
        String arch = System.getProperty("os.arch");
        if (PlatformUtil.isLinux()) {
            if (arch.endsWith("86")) {
                arch = "x86";
            }
        } else if (PlatformUtil.isSun() && arch.endsWith("86")) {
            arch = "i386";
        }
        return arch;
    }

    public static final String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static final String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static final String getUserName() {
        return System.getProperty("user.name");
    }

    public static final String getVMVersion() {
        String ret = System.getProperty("java.vm.version");
        if (ret == null) {
            return PlatformUtil.getMsVersion();
        }
        return ret;
    }

    public static final String getVMInfo() {
        String ret = System.getProperty("java.vm.info");
        if (ret == null) {
            return PlatformUtil.getMsVersion();
        }
        return ret;
    }

    public static final boolean isWin() {
        return is95 || is98 || isNT || is2000 || isXP;
    }

    public static final boolean is98() {
        return is98;
    }

    public static final boolean is95() {
        return is95;
    }

    public static final boolean isNT() {
        return isNT;
    }

    public static final boolean is2000() {
        return is2000;
    }

    public static final boolean isOS2() {
        return isos2;
    }

    public static final boolean isMac() {
        return ismac;
    }

    public static final boolean isSun() {
        return isSun;
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    public static final boolean isUnix() {
        return isSun || isLinux;
    }

    public static final boolean isJava2() {
        return isJava2;
    }

    public static final boolean isJava1() {
        return is1_1;
    }

    public static final boolean isJview() {
        return isJview;
    }

    public static final boolean isJDK1_4() {
        return is1_4;
    }

    public static final boolean isJDK1_5() {
        return is1_5;
    }

    public static final boolean isJDK1_3() {
        return is1_3;
    }

    public static final boolean isJDK1_2() {
        return is1_2;
    }

    public static final boolean isJDK1_1() {
        return is1_1;
    }

    public static final void loadWinSock() {
        if (isJview) {
            return;
        }
        try {
            System.out.println("%% LOAD WINSOCK");
            System.loadLibrary("wsock32");
            PlatformUtil.getLocalHost();
        }
        catch (Throwable e) {
            System.out.println("loadWinSock:" + e);
        }
    }

    public static final String viewSystemInfo() {
        StringBuffer s = new StringBuffer("System Properties!! \n");
        s.append("\n VM Version ");
        s.append(PlatformUtil.getVMVersion());
        s.append("\n VM Info ");
        s.append(PlatformUtil.getVMInfo());
        s.append("\n");
        Enumeration<Object> e = System.getProperties().keys();
        String tmp = "";
        while (e.hasMoreElements()) {
            tmp = (String)e.nextElement();
            s.append(tmp + " = " + System.getProperty(tmp) + "\n");
        }
        tmp = null;
        e = null;
        return s.toString();
    }

    public static final String getLocalHost() {
        try {
            System.out.println(".*. Getting Local Host .*.");
            InetAddress addr = InetAddress.getLocalHost();
            return addr.toString();
        }
        catch (Exception e) {
            System.out.println("getLocalHost:" + e);
            return "";
        }
    }

    public static final void forceWin() {
        is98 = true;
        isos2 = false;
    }

    public static final void forceOS2() {
        isos2 = true;
        is98 = false;
        isNT = false;
        is95 = false;
        ismac = false;
        isunix = false;
    }

    public static final void forceMac() {
        isos2 = false;
        is98 = false;
        isNT = false;
        is95 = false;
        ismac = true;
        isunix = false;
    }

    public static final void forceUnix(boolean b) {
        isos2 = false;
        is98 = false;
        isNT = false;
        is95 = false;
        ismac = false;
        isunix = true;
    }

    public static final void forceJava2(boolean b) {
        is1_2 = b;
        is1_1 = !b;
    }

    public static final void forceJava1(boolean b) {
        is1_1 = b;
        is1_2 = !b;
    }

    public static final File getTempFile(File f) {
        if (PlatformUtil.isWin()) {
            return f;
        }
        return new File(f.getAbsolutePath() + ".tmp");
    }

    public static final boolean renameTempFile(File temp, File f) {
        if (!PlatformUtil.isWin()) {
            return temp.renameTo(f);
        }
        return true;
    }

    static {
        String t = PlatformUtil.getOSName();
        if (t.equalsIgnoreCase(WIN95_ID)) {
            if (PlatformUtil.getOSVersion().equals("4.0")) {
                is95 = true;
            } else {
                is98 = true;
            }
        } else if (t.equalsIgnoreCase(WIN98_ID)) {
            is98 = true;
        } else if (t.equalsIgnoreCase(WINNT_ID)) {
            if (PlatformUtil.getOSVersion().equals("5.0")) {
                is2000 = true;
            } else {
                isNT = true;
            }
        } else if (t.equalsIgnoreCase(WIN2K_ID)) {
            is2000 = true;
        } else if (t.equalsIgnoreCase(WINXP_ID)) {
            isXP = true;
        } else if (t.equalsIgnoreCase(OS2_ID)) {
            isos2 = true;
        } else if (t.equalsIgnoreCase(SUN_ID)) {
            isSun = true;
        } else if (t.toLowerCase().startsWith(MAC_ID)) {
            ismac = true;
        } else if (t.equalsIgnoreCase(LINUX_ID)) {
            isLinux = true;
        }
        t = PlatformUtil.getJavaVersion();
        if (t.startsWith("1.5")) {
            is1_5 = true;
        } else if (t.startsWith("1.4")) {
            is1_4 = true;
        } else if (t.startsWith("1.3")) {
            is1_3 = true;
        } else if (t.startsWith("1.2")) {
            is1_2 = true;
        } else if (t.startsWith("1.1")) {
            isJava2 = false;
            is1_1 = true;
        }
        t = System.getProperty("java.vendor");
        if (t.startsWith("Microsoft")) {
            isJview = true;
            PlatformUtil.getMsVersion();
        }
        Object var0 = null;
    }
}

