/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.Worker;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class NioSelectWorker
implements Runnable {
    LinkedList registerList = new LinkedList();
    LinkedList cancelList = new LinkedList();
    Selector mySelector = Selector.open();
    String logPrefix = "NioSelectWorker: ";
    boolean stop = false;
    Worker worker;

    public NioSelectWorker(int minThreads, int maxThreads) throws Exception {
        this.worker = new Worker(minThreads, maxThreads, "NioSelectWorker");
    }

    public void close() {
        this.stop = true;
        try {
            this.mySelector.wakeup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.stop) {
                Selection sel;
                Iterator<Object> iter;
                int n = this.mySelector.select();
                Object object = this.cancelList;
                synchronized (object) {
                    iter = this.cancelList.iterator();
                    while (iter.hasNext()) {
                        sel = (Selection)iter.next();
                        if (sel.key != null) {
                            sel.key.cancel();
                        }
                        try {
                            sel.closeChannel();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.cancelList.clear();
                }
                object = this.registerList;
                synchronized (object) {
                    iter = this.registerList.iterator();
                    while (iter.hasNext()) {
                        sel = (Selection)iter.next();
                        if (!sel.isOpen()) continue;
                        sel.register(this.mySelector);
                    }
                    this.registerList.clear();
                }
                object = this;
                synchronized (object) {
                    iter = this.mySelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = (SelectionKey)iter.next();
                        iter.remove();
                        if ((!key.isValid() || (key.interestOps() & 1) == 0 || !key.isReadable()) && ((key.interestOps() & 4) == 0 || !key.isWritable())) continue;
                        Runnable runnable = (Runnable)key.attachment();
                        int q = this.worker.addRunnable(runnable);
                        key.cancel();
                    }
                }
            }
            this.mySelector.close();
            this.worker.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.logPrefix + e.toString());
        }
    }

    public Selection register(SelectableChannel channel, Runnable runnable) throws IOException {
        channel.configureBlocking(false);
        Selection selection = new Selection(channel, runnable);
        this.reRegister(selection);
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegister(Selection selection) {
        LinkedList linkedList = this.registerList;
        synchronized (linkedList) {
            this.registerList.add(selection);
        }
        this.mySelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Object o) {
        if (!(o instanceof Selection)) {
            return;
        }
        Selection sel = (Selection)o;
        LinkedList linkedList = this.cancelList;
        synchronized (linkedList) {
            this.cancelList.add(sel);
        }
        this.mySelector.wakeup();
    }

    public SelectableChannel getChannel(Object o) {
        if (o instanceof Selection) {
            return ((Selection)o).getChannel();
        }
        if (o instanceof SelectionKey) {
            SelectionKey key = (SelectionKey)o;
            Object sel = key.attachment();
            if (!(sel instanceof Selection)) {
                return null;
            }
            return ((Selection)sel).getChannel();
        }
        throw new IllegalArgumentException("Unexpected argument class: " + (o != null ? o.getClass().toString() : "null"));
    }

    public Object attachment(Object o) {
        if (o instanceof Selection) {
            return ((Selection)o).runnable;
        }
        if (o instanceof SelectionKey) {
            SelectionKey key = (SelectionKey)o;
            Object sel = key.attachment();
            if (!(sel instanceof Selection)) {
                return null;
            }
            return ((Selection)sel).runnable;
        }
        throw new IllegalArgumentException("Unexpected argument class: " + (o != null ? o.getClass().toString() : "null"));
    }

    public Set keys() {
        return this.mySelector.keys();
    }

    class Selection
    implements Runnable {
        SelectableChannel channel;
        Runnable runnable;
        SelectionKey key;
        int operation = 1;

        Selection(SelectableChannel channel, Runnable runnable) {
            this.channel = channel;
            this.runnable = runnable;
        }

        void closeChannel() throws IOException {
            this.channel.close();
        }

        SelectableChannel getChannel() {
            return this.channel;
        }

        boolean isOpen() {
            return this.channel.isOpen();
        }

        void register(Selector selector) throws ClosedChannelException {
            this.key = this.channel.register(selector, this.operation, this);
        }

        int operation() {
            return this.operation;
        }

        public void run() {
            this.runnable.run();
            NioSelectWorker.this.reRegister(this);
        }
    }
}

