/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.shells;

import com.sun.im.service.ConferenceEvent;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.NewsService;
import com.sun.im.service.shells.Shell;
import com.sun.im.service.shells.ShellConference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ShellNewsChannel
extends ShellConference
implements NewsChannelListener {
    int _messageIdCount = 0;
    Map _messageIdToNumber = new HashMap();
    Map _numberToMessageId = new HashMap();
    Map _messages;

    public ShellNewsChannel(String uid, NewsService s, String name, boolean subscribe) throws Exception {
        super(uid, name);
        this._conf = subscribe ? s.getNewsChannel(name, this) : s.getNewsChannel(name, null);
        if (this._conf == null) {
            throw new NoSuchElementException("news channel " + name + " does not exist");
        }
        this._messages = new HashMap();
        System.out.println("Got news channel " + this._conf.getDestination());
    }

    public ShellNewsChannel(String uid, NewsService s, String name, int accessLevel) throws Exception {
        super(uid, name);
        this._conf = s.newNewsChannel(name, this, accessLevel);
        this._messages = new HashMap();
        System.out.println("Created news channel " + this._conf.getDestination());
    }

    public synchronized void onMessageAdded(Message message) {
        System.out.println("[" + this._uid + ":" + this._conf.getDestination() + "] message added -- " + message.getHeader("subject"));
        Shell.printMessage(message);
        String msgId = message.getMessageId();
        this._messages.put(msgId, message);
        if (this._messageIdToNumber.get(msgId) == null) {
            this._messageIdToNumber.put(msgId, Integer.toString(this._messageIdCount));
            this._numberToMessageId.put(Integer.toString(this._messageIdCount), msgId);
            ++this._messageIdCount;
        }
    }

    public void onEvent(ConferenceEvent event) {
        ConferenceEventHelper ch = null;
        try {
            ch = new ConferenceEventHelper(((Object)event).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList tuples = (ArrayList)ch.getTuples();
        for (int i = 0; i < tuples.size(); ++i) {
            ConferenceEventTuple t = (ConferenceEventTuple)tuples.get(i);
            System.out.println("Destination  " + t.destination + " status " + t.status);
        }
    }

    public void onMessageRemoved(String messageId) {
        System.out.println("[" + this._uid + ":" + this._conf.getDestination() + "] message removed -- ");
        this._messages.remove(messageId);
    }

    public void onMessageModified(String messageId, Message message) {
        System.out.println("[" + this._uid + ":" + this._conf.getDestination() + "] message modified -- ");
        this._messages.put(messageId, message);
    }

    public void listMessages() throws Exception {
        if (this._messages.size() == 0) {
            Thread.sleep(500L);
        }
        Collection c = this._messages.values();
        System.out.println("*** Start message list for news channel " + this._conf.getDestination());
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            System.out.println("id: " + this._messageIdToNumber.get(m.getMessageId()));
            Shell.printMessage(m);
        }
        System.out.println("*** End message list for news channel " + this._conf.getDestination());
    }
}

