/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.shells;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.Message;
import com.sun.im.service.shells.Shell;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class ShellConference
implements ConferenceListener {
    String _uid = null;
    String _name;
    Conference _conf;
    ConferenceService _confService;
    Shell _shell;

    public ShellConference(String uid, ConferenceService s, String name, boolean create, boolean join) throws Exception {
        this._uid = uid;
        this._confService = s;
        this._name = name;
        this._conf = create ? s.setupPublicConference(name, this, 4) : (join ? s.joinPublicConference(name, this) : s.getPublicConference(name));
        if (this._conf == null) {
            throw new NoSuchElementException("Conference " + name + " does not exist");
        }
    }

    public ShellConference(String uid, ConferenceService s, String localName) throws Exception {
        this._uid = uid;
        this._confService = s;
        this._name = localName;
        this._conf = s.setupConference(this, 30);
    }

    public ShellConference(String uid, ConferenceService s, Conference c) throws Exception {
        this(uid, s, c, c.getDestination());
    }

    public ShellConference(String uid, ConferenceService s, Conference c, String localName) throws Exception {
        this._uid = uid;
        this._confService = s;
        this._conf = c;
        this._name = localName;
        c.join(this);
    }

    public ShellConference(String uid, String name) throws Exception {
        this._uid = uid;
        this._name = name;
    }

    public void setShell(Shell s) {
        this._shell = s;
    }

    public void onMessageAdded(Message message) {
        System.out.println("[" + this._uid + ":" + this._name + "] message added -- " + message.getHeader("subject"));
        Shell.printMessage(message);
    }

    public void onEvent(String event) {
        ConferenceEventHelper ch = null;
        try {
            ch = new ConferenceEventHelper(event);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList tuples = (ArrayList)ch.getTuples();
        for (int i = 0; i < tuples.size(); ++i) {
            ConferenceEventTuple t = (ConferenceEventTuple)tuples.get(i);
            try {
                System.out.println("\n[ConferenceEvent Received] Conference=<" + this._name + "> Recipient=<" + this._uid + "> Destination=<" + t.destination + "> status=<" + t.status + ">");
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception: " + e);
                break;
            }
        }
    }

    public void onError(CollaborationException e) {
    }

    public Conference getConference() {
        return this._conf;
    }

    public void onModeratedMessageAdded(Message message) {
        System.out.println("[" + this._uid + ":" + this._name + "] moderated message added -- " + message.getHeader("subject"));
        Shell.printMessage(message);
    }

    public void onModeratedMessageStatus(Message message, int status, String reason) {
        System.out.println("[" + this._uid + ":" + this._name + "] moderated message status -- " + message.getHeader("subject"));
        System.out.println("Status: " + status + " Reason: " + reason);
        Shell.printMessage(message);
        try {
            this._shell.handleModeratedMessage(this._conf, message, status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

