/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.sample;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.sample.Talk;
import java.util.Iterator;

class TalkConference
implements ConferenceListener,
InviteMessageStatusListener {
    String _name;
    String _user;
    Conference _conf;

    public TalkConference(String user, ConferenceSession s) throws Exception {
        this._user = user;
        this._conf = s.setupConference(this, 30);
        this._name = this._conf.getDestination();
        this._conf.join(this);
    }

    public TalkConference(String user, ConferenceSession s, Conference c) throws Exception {
        this._user = user;
        this._conf = c;
        this._name = this._conf.getDestination();
        c.join(this);
    }

    public void addMessage(String msg) throws Exception {
        Message newMsg = this._conf.createMessage();
        MessagePart part = newMsg.newPart();
        part.setContentType("text/plain");
        part.setContent(msg);
        newMsg.addPart(part);
        newMsg.setOriginator("yoyo@yoyo.com");
        this._conf.addMessage(newMsg);
    }

    public void onMessageAdded(Message message) {
        if (!message.getOriginator().startsWith(this._user + "@")) {
            Talk.printMessage(message);
        }
    }

    public void onEvent(String event) {
        try {
            ConferenceEventHelper ceh = new ConferenceEventHelper(event);
            Iterator i = ceh.getTuples().iterator();
            while (i.hasNext()) {
                ConferenceEventTuple cet = (ConferenceEventTuple)i.next();
                if (cet.status.equals("on")) {
                    System.out.println("*** " + cet.destination + " has joined " + this._name);
                    continue;
                }
                System.out.println("*** " + cet.destination + " has left " + this._name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void leave() {
        this._conf.leave();
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
    }

    public String getDestination() {
        return this._name;
    }

    public Message createInviteMessage() throws Exception {
        return this._conf.createInviteMessage();
    }

    public void invite(Message m) throws Exception {
        this._conf.invite(30, m, this);
    }

    public void onRsvp(String destination, Message message, boolean accepted) {
        this.onRsvp(destination, accepted);
        Talk.printMessage(message);
    }

    public void onRsvp(String destination, boolean accepted) {
        if (accepted) {
            System.out.println(destination + " accepted your invitation.");
        } else {
            System.out.println(destination + " declined your invitation.");
        }
    }

    public void onModeratedMessageAdded(Message message) {
    }

    public void onModeratedMessageStatus(Message message, int status, String reason) {
    }
}

