/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.jso.x.muc;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.x.muc.History;

public class HistoryNode
extends ElementNode
implements History {
    public static final NSI ATTRNAME_MAXCHARS = new NSI("maxchars", null);
    public static final NSI ATTRNAME_MAXSTANZAS = new NSI("maxstanzas", null);
    public static final NSI ATTRNAME_SECONDS = new NSI("seconds", null);
    public static final NSI ATTRNAME_SINCE = new NSI("since", null);

    public HistoryNode(StreamDataFactory sdf, String namespace) {
        super(sdf, new NSI("history", namespace));
    }

    protected HistoryNode(StreamElement parent, HistoryNode base) {
        super(parent, (ElementNode)base);
    }

    public int getMaxChars() {
        Object val = this.getAttributeObject(ATTRNAME_MAXCHARS);
        int maxchars = -1;
        if (val instanceof Number) {
            maxchars = ((Number)val).intValue();
        } else if (val != null) {
            Integer temp = null;
            try {
                temp = Integer.valueOf(val.toString());
                maxchars = temp;
                this.setAttributeObject(ATTRNAME_MAXCHARS, temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return maxchars;
    }

    public int getMaxStanzas() {
        Object val = this.getAttributeObject(ATTRNAME_MAXSTANZAS);
        int maxstanzas = -1;
        if (val instanceof Number) {
            maxstanzas = ((Number)val).intValue();
        } else if (val != null) {
            Integer temp = null;
            try {
                temp = Integer.valueOf(val.toString());
                maxstanzas = temp;
                this.setAttributeObject(ATTRNAME_MAXSTANZAS, temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return maxstanzas;
    }

    public int getSeconds() {
        Object val = this.getAttributeObject(ATTRNAME_SECONDS);
        int seconds = -1;
        if (val instanceof Number) {
            seconds = ((Number)val).intValue();
        } else if (val != null) {
            Integer temp = null;
            try {
                temp = Integer.valueOf(val.toString());
                seconds = temp;
                this.setAttributeObject(ATTRNAME_SECONDS, temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return seconds;
    }

    public Date getSince() {
        String val = this.getAttributeValue(ATTRNAME_SINCE);
        try {
            return val != null ? DateFormat.getInstance().parse(val) : null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public void setMaxChars(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("maxchars cannot be less than 0");
        }
        this.setAttributeObject(ATTRNAME_MAXCHARS, new Integer(n));
    }

    public void setMaxStanzas(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("maxstanzas cannot be less than 0");
        }
        this.setAttributeObject(ATTRNAME_MAXSTANZAS, new Integer(n));
    }

    public void setSeconds(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("seconds cannot be less than 0");
        }
        this.setAttributeObject(ATTRNAME_SECONDS, new Integer(n));
    }

    public void setSince(Date dateTime) throws IllegalArgumentException {
        if (dateTime == null) {
            throw new IllegalArgumentException("datetime cannot be null");
        }
        this.setAttributeValue(ATTRNAME_SINCE, dateTime.toString());
    }

    public StreamObject copy(StreamElement parent) {
        return new HistoryNode(parent, this);
    }
}

