/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.PollHelperAnswer;
import com.sun.im.service.util.SAX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PollHelper
extends DefaultHandler {
    private ArrayList _answers = new ArrayList(3);
    private String _customId = null;
    private String _question;
    private String _pollID = null;
    private String _pollType = null;
    private String _access = null;
    private int _state;
    private PollHelperAnswer _currentAnswer;
    private static final int IN_ID = 1;
    private static final int IN_POLLTYPE = 2;
    private static final int IN_ACCESS = 3;
    private static final int IN_QUESTION = 4;
    private static final int IN_ANSWER = 5;
    private static final int IN_CUSTOM = 6;
    public static final String ELEMENT_FIELD = "field";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_OPTION = "option";
    public static final String ATTRIBUTE_VAR = "var";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_QUESTION = "question";
    public static final String ATTRIBUTE_POLLTYPE = "polltype";
    public static final String ATTRIBUTE_ACCESS = "access";
    public static final String ATTRIBUTE_CUSTOM = "custom";
    private JSOImplementation _jso = JSOImplementation.getInstance();
    private StreamDataFactory _sdf = this._jso.createDataFactory();

    public PollHelper(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)this);
    }

    public PollHelper(String message) throws Exception {
        SAX.parse(message, (DefaultHandler)this);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this._state) {
            case 1: {
                this._pollID = String.copyValueOf(ch, start, length);
                break;
            }
            case 2: {
                this._pollType = String.copyValueOf(ch, start, length);
                break;
            }
            case 5: {
                this._currentAnswer.id = String.copyValueOf(ch, start, length);
                this._answers.add(this._currentAnswer);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this._access = String.copyValueOf(ch, start, length);
                break;
            }
            default: {
                throw new SAXException("No characters at this stage: ");
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String nsuri, String localName, String fqName) throws SAXException {
    }

    public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
        if (fqName.equals(ELEMENT_FIELD)) {
            String attr = attributes.getValue(ATTRIBUTE_VAR);
            if (attr.equals(ATTRIBUTE_ID)) {
                this._state = 1;
            } else if (attr.equals(ATTRIBUTE_POLLTYPE)) {
                this._state = 2;
            } else if (attr.equals(ATTRIBUTE_ACCESS)) {
                this._state = 3;
            } else if (attr.equals(ATTRIBUTE_CUSTOM)) {
                this._state = 6;
                this._customId = ATTRIBUTE_CUSTOM;
            } else if (attr.equals(ATTRIBUTE_QUESTION)) {
                this._state = 4;
                this._question = attributes.getValue(ATTRIBUTE_LABEL);
            }
        } else if (!fqName.equals(ELEMENT_VALUE) && fqName.equals(ELEMENT_OPTION)) {
            this._state = 5;
            this._currentAnswer = new PollHelperAnswer();
            this._currentAnswer.text = new StringBuffer();
            this._currentAnswer.text.append(attributes.getValue(ATTRIBUTE_LABEL));
        }
    }

    public String getPollID() {
        return this._pollID;
    }

    public String getQuestion() {
        return this._question;
    }

    public int countAnswers() {
        return this._answers.size();
    }

    public String getAnswer(int index) throws IndexOutOfBoundsException {
        PollHelperAnswer a = (PollHelperAnswer)this._answers.get(index);
        if (a == null) {
            throw new IndexOutOfBoundsException();
        }
        return a.text.toString();
    }

    public String createResponse(int index) {
        XDataForm xdf = (XDataForm)this._sdf.createElementNode(new NSI("x", "jabber:x:data"), null);
        xdf.setType(XDataForm.SUBMIT);
        if (this._pollID != null) {
            XDataField f1 = xdf.addField(ATTRIBUTE_ID);
            f1.addValue(this._pollID);
        }
        PollHelperAnswer a = (PollHelperAnswer)this._answers.get(index);
        XDataField f = xdf.addField(ATTRIBUTE_QUESTION);
        f.addValue(a.id);
        return xdf.toString();
    }

    public String createResponse(String answer) throws CollaborationException {
        for (int i = 0; i < this._answers.size(); ++i) {
            if (!answer.equals(((PollHelperAnswer)this._answers.get((int)i)).text.toString())) continue;
            return this.createResponse(i);
        }
        if (this._customId != null) {
            XDataForm xdf = (XDataForm)this._sdf.createElementNode(new NSI("x", "jabber:x:data"), null);
            xdf.setType(XDataForm.SUBMIT);
            if (this._pollID != null) {
                XDataField f1 = xdf.addField(ATTRIBUTE_ID);
                f1.addValue(this._pollID);
            }
            XDataField a = xdf.addField(ATTRIBUTE_CUSTOM);
            a.addValue(answer);
            return xdf.toString();
        }
        throw new CollaborationException("Custom answer not allowed for this poll: " + answer);
    }

    public InputStream createResponseStream(String answer) throws CollaborationException {
        byte[] buf = this.createResponse(answer).getBytes();
        return new ByteArrayInputStream(buf, 0, buf.length);
    }

    public boolean isCustomAnswerAllowed() {
        return this._customId != null;
    }
}

