/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.PollAnswer;
import com.sun.im.service.util.SAX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Poll {
    private LinkedList _answers = new LinkedList();
    private String _customId = null;
    private String _question;
    private String _pollID;
    private String _pollType = null;
    private String _access = null;
    private boolean _quote;
    private boolean _customAnswerAllowed = false;
    private PollAnswer _lastParsedAnswer;
    private static final int IN_ID = 1;
    private static final int IN_POLLTYPE = 2;
    private static final int IN_ACCESS = 3;
    private static final int IN_QUESTION = 4;
    private static final int IN_ANSWER = 5;
    private static final int IN_CUSTOM = 6;
    public static final String ELEMENT_FIELD = "field";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_OPTION = "option";
    public static final String ATTRIBUTE_VAR = "var";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_QUESTION = "question";
    public static final String ATTRIBUTE_POLLTYPE = "polltype";
    public static final String ATTRIBUTE_ACCESS = "access";
    public static final String ATTRIBUTE_CUSTOM = "custom";
    public static final String POLLTYPE_ANONYMOUS = "anon";
    public static final String POLLTYPE_OPEN = "open";
    public static final String POLLACCESS_PRIVATE = "private";
    public static final String POLLACCESS_PARTICIPANTS = "participants";
    public static final String POLLACCESS_PUBLIC = "public";
    public static final String POLLACCESS_NONE = "none";
    private JSOImplementation _jso = JSOImplementation.getInstance();
    private StreamDataFactory _sdf = this._jso.createDataFactory();

    public Poll(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)new PollMessageParser());
    }

    public Poll(String message) throws Exception {
        SAX.parse(message, (DefaultHandler)new PollMessageParser());
    }

    public Poll(String question, List answers, boolean custom) {
        this._question = question;
        this._pollID = this._jso.toString();
        this.loadAnswers(answers);
        this._customAnswerAllowed = custom;
    }

    public Poll(String pollID, String question, List answers, boolean custom, String pollType, String access) {
        this._pollID = pollID;
        this._question = question;
        this._customAnswerAllowed = custom;
        this._access = access;
        this._pollType = pollType;
        this.loadAnswers(answers);
    }

    private void loadAnswers(List answers) {
        for (int i = 0; i < answers.size(); ++i) {
            this._answers.add(new PollAnswer(Integer.toString(i), (String)answers.get(i)));
        }
    }

    public String getPollID() {
        return this._pollID;
    }

    public String getQuestion() {
        return this._question;
    }

    public int countAnswers() {
        return this._answers.size();
    }

    public String getAnswer(int index) throws IndexOutOfBoundsException {
        PollAnswer a = (PollAnswer)this._answers.get(index);
        if (a == null) {
            throw new IndexOutOfBoundsException();
        }
        return a.text;
    }

    public String createResponse(int index) throws CollaborationException {
        PollAnswer a = (PollAnswer)this._answers.get(index);
        return this.createResponse(a.text);
    }

    public XDataForm createXDataResponse(String answer) throws CollaborationException {
        XDataForm xdf = (XDataForm)this._sdf.createElementNode(new NSI("x", "jabber:x:data"), null);
        xdf.setType(XDataForm.SUBMIT);
        if (this._pollID != null) {
            XDataField f1 = xdf.addField(ATTRIBUTE_ID);
            f1.addValue(this._pollID);
        }
        for (int i = 0; i < this._answers.size(); ++i) {
            if (!answer.equals(((PollAnswer)this._answers.get((int)i)).text.toString())) continue;
            XDataField a = xdf.addField(ATTRIBUTE_QUESTION);
            a.addValue(answer);
            return xdf;
        }
        if (this._customAnswerAllowed) {
            XDataField a = xdf.addField(ATTRIBUTE_CUSTOM);
            a.addValue(answer);
            return xdf;
        }
        throw new CollaborationException("Custom answer no allowed for this poll: " + answer);
    }

    public String createResponse(String answer) throws CollaborationException {
        return this.createXDataResponse(answer).toString();
    }

    public InputStream createResponseStream(String answer) throws CollaborationException {
        byte[] buf = this.createResponse(answer).getBytes();
        return new ByteArrayInputStream(buf, 0, buf.length);
    }

    public boolean isCustomAnswerAllowed() {
        return this._customAnswerAllowed;
    }

    public boolean isAnonynous() {
        return this._pollType != null && this._pollType.equalsIgnoreCase(POLLTYPE_ANONYMOUS);
    }

    public String getAccess() {
        return this._access;
    }

    public String createResponse(String pollID, String answer) throws CollaborationException {
        this._pollID = pollID;
        return this.createResponse(answer);
    }

    private PollAnswer findAnswer(String answer) {
        Iterator i = this._answers.iterator();
        while (i.hasNext()) {
            PollAnswer a = (PollAnswer)i.next();
            if (a.text == null || !answer.equals(a.text)) continue;
            return a;
        }
        if (this._customAnswerAllowed) {
            PollAnswer a = new PollAnswer();
            a.text = answer;
            return a;
        }
        return null;
    }

    private PollAnswer findAnswerFromId(String id) {
        Iterator i = this._answers.iterator();
        while (i.hasNext()) {
            PollAnswer a = (PollAnswer)i.next();
            if (a.id == null || !id.equals(a.id)) continue;
            return a;
        }
        return null;
    }

    public String parseAnswer(InputStream in) throws Exception {
        SAX.parse(in, (DefaultHandler)new PollResponseParser());
        if (this._lastParsedAnswer == null) {
            throw new Exception("Answer does not match anything");
        }
        return this._lastParsedAnswer.text;
    }

    public synchronized String parseAnswer(String str) throws Exception {
        SAX.parse(str, (DefaultHandler)new PollResponseParser());
        if (this._lastParsedAnswer == null) {
            throw new Exception("Answer does not match anything");
        }
        return this._lastParsedAnswer.text;
    }

    public int getCount(String answerID) {
        return 0;
    }

    public XDataForm getXDataForm() {
        XDataForm xdf = (XDataForm)this._sdf.createElementNode(new NSI("x", "jabber:x:data"), null);
        xdf.setType(XDataForm.FORM);
        if (this._pollID != null) {
            XDataField f1 = xdf.addField(ATTRIBUTE_ID, XDataField.HIDDEN);
            f1.addValue(this._pollID);
        }
        if (this._pollType != null) {
            XDataField f2 = xdf.addField(ATTRIBUTE_POLLTYPE, XDataField.HIDDEN);
            f2.addValue(this._pollType);
        }
        if (this._access != null) {
            XDataField f3 = xdf.addField(ATTRIBUTE_ACCESS, XDataField.HIDDEN);
            f3.addValue(this._access);
        }
        XDataField q = xdf.addField(ATTRIBUTE_QUESTION, XDataField.LIST_SINGLE);
        q.setLabel(this._question);
        for (int i = 0; i < this._answers.size(); ++i) {
            PollAnswer a = (PollAnswer)this._answers.get(i);
            q.addOption(a.text, a.id);
        }
        if (this._customAnswerAllowed) {
            XDataField c = xdf.addField(ATTRIBUTE_CUSTOM, XDataField.TEXT_SINGLE);
            c.setLabel("Custom Reply");
        }
        return xdf;
    }

    public String toString() {
        return this.getXDataForm().toString();
    }

    public static void main(String[] arg) {
    }

    class PollResponseParser
    extends DefaultHandler {
        private int _state;
        private PollAnswer _currentAnswer = null;
        private StringBuffer _quotedAnswer = null;
        private StringBuffer _id = null;

        PollResponseParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = String.copyValueOf(ch, start, length);
            if ("\n".equals(s)) {
                return;
            }
            switch (this._state) {
                case 5: {
                    this._id.append(ch, start, length);
                    this._currentAnswer = Poll.this.findAnswerFromId(this._id.toString());
                    break;
                }
                case 6: {
                    this._quotedAnswer.append(ch, start, length);
                    break;
                }
                case 1: {
                    Poll.this._pollID = s;
                    break;
                }
                case 2: {
                    Poll.this._pollType = s;
                    break;
                }
                case 3: {
                    Poll.this._access = s;
                    break;
                }
                default: {
                    throw new SAXException("No characters at this stage");
                }
            }
        }

        public void startDocument() throws SAXException {
            Poll.this._lastParsedAnswer = null;
        }

        public void endDocument() throws SAXException {
            if (this._currentAnswer == null && this._quotedAnswer != null) {
                this._currentAnswer = Poll.this.findAnswer(this._quotedAnswer.toString());
            }
            Poll.this._lastParsedAnswer = this._currentAnswer;
        }

        public void endElement(String nsuri, String localName, String fqName) throws SAXException {
            if ((this._state == 5 || this._state == 6) && this._currentAnswer != null) {
                ++this._currentAnswer.count;
            }
        }

        public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
            if (fqName.equals(Poll.ELEMENT_FIELD)) {
                String attr = attributes.getValue(Poll.ATTRIBUTE_VAR);
                if (attr.equals(Poll.ATTRIBUTE_ID)) {
                    this._state = 1;
                } else if (attr.equals(Poll.ATTRIBUTE_ACCESS)) {
                    this._state = 3;
                } else if (attr.equals(Poll.ATTRIBUTE_POLLTYPE)) {
                    this._state = 2;
                } else if (attr.equals(Poll.ATTRIBUTE_QUESTION)) {
                    this._state = 5;
                } else if (attr.equals(Poll.ATTRIBUTE_CUSTOM)) {
                    this._state = 6;
                }
            } else if (fqName.equals(Poll.ELEMENT_VALUE)) {
                this._id = new StringBuffer();
                this._quotedAnswer = new StringBuffer();
            }
        }
    }

    class PollMessageParser
    extends DefaultHandler {
        private int _state;
        private PollAnswer _answer;

        PollMessageParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this._state) {
                case 1: {
                    Poll.this._pollID = String.copyValueOf(ch, start, length);
                    break;
                }
                case 2: {
                    Poll.this._pollType = String.copyValueOf(ch, start, length);
                    break;
                }
                case 5: {
                    this._answer.id = String.copyValueOf(ch, start, length);
                    Poll.this._answers.add(this._answer);
                    break;
                }
                case 3: {
                    Poll.this._access = String.copyValueOf(ch, start, length);
                    break;
                }
                default: {
                    throw new SAXException("No characters at this stage: ");
                }
            }
        }

        public void startDocument() throws SAXException {
        }

        public void endElement(String nsuri, String localName, String fqName) throws SAXException {
        }

        public void startElement(String nsuri, String localName, String fqName, Attributes attributes) throws SAXException {
            if (fqName.equals(Poll.ELEMENT_FIELD)) {
                String attr = attributes.getValue(Poll.ATTRIBUTE_VAR);
                if (attr.equals(Poll.ATTRIBUTE_ID)) {
                    this._state = 1;
                } else if (attr.equals(Poll.ATTRIBUTE_POLLTYPE)) {
                    this._state = 2;
                } else if (attr.equals(Poll.ATTRIBUTE_ACCESS)) {
                    this._state = 3;
                } else if (attr.equals(Poll.ATTRIBUTE_CUSTOM)) {
                    this._state = 6;
                    Poll.this._customAnswerAllowed = true;
                } else if (attr.equals(Poll.ATTRIBUTE_QUESTION)) {
                    this._state = 4;
                    Poll.this._question = attributes.getValue(Poll.ATTRIBUTE_LABEL);
                }
            } else if (!fqName.equals(Poll.ELEMENT_VALUE) && fqName.equals(Poll.ELEMENT_OPTION)) {
                this._state = 5;
                this._answer = new PollAnswer();
                this._answer.text = attributes.getValue(Poll.ATTRIBUTE_LABEL);
            }
        }
    }
}

