/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.MultiplexConnectionFactory;
import com.iplanet.im.net.MultiplexSocket;
import com.sun.im.service.util.HostPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class MultiplexSocketFactory {
    private ArrayList _sockets = new ArrayList();
    public static final String CAPACITY_PROP_NAME = "com.iplanet.im.mux.capacity";
    public static final String MAXCONNS_PROP_NAME = "com.iplanet.im.mux.maxconns";
    private static int _capacity = 256;
    private static int _maxconns = -1;

    private synchronized MultiplexSocket findSocket(InetAddress inetAddress, int n) throws IOException {
        MultiplexSocket multiplexSocket = null;
        Iterator iterator = this._sockets.iterator();
        while (iterator.hasNext()) {
            multiplexSocket = (MultiplexSocket)iterator.next();
            if (!multiplexSocket.matches(inetAddress, n) || multiplexSocket.isPrettyFull()) continue;
            return multiplexSocket;
        }
        if (_maxconns < 1 || this._sockets.size() < _maxconns) {
            multiplexSocket = new MultiplexSocket(this, inetAddress, n, _capacity);
            this._sockets.add(0, multiplexSocket);
            return multiplexSocket;
        }
        throw new IOException("TCP connection limit exceeded");
    }

    public MultiplexConnectionFactory createChannel(InetAddress inetAddress, int n, Properties properties) throws IOException, UnknownHostException {
        String string = properties.getProperty("net.nms", "localhost");
        HostPort hostPort = new HostPort(string, 9999);
        MultiplexSocket multiplexSocket = this.findSocket(hostPort.getHost(), hostPort.getPort());
        return multiplexSocket.createChannel(inetAddress, n, properties);
    }

    public void close() {
        while (this._sockets.size() > 0) {
            try {
                MultiplexSocket multiplexSocket = (MultiplexSocket)this._sockets.remove(0);
                multiplexSocket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._sockets.clear();
    }

    public synchronized void remove(MultiplexSocket multiplexSocket) {
        this._sockets.remove(multiplexSocket);
    }

    static {
        try {
            String string = System.getProperty(CAPACITY_PROP_NAME);
            if (string != null) {
                _capacity = Integer.parseInt(string) * 2;
            }
            if ((string = System.getProperty(MAXCONNS_PROP_NAME)) != null) {
                _maxconns = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

