/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.CommandToNet;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.MultiplexConnectionFactory;
import com.iplanet.im.net.MultiplexSocketFactory;
import com.sun.im.service.util.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;

class MultiplexSocket
extends Socket {
    private MultiplexConnectionFactory[] _channel;
    private int _numChannels = 0;
    private int _lastIndex;
    private int _capacity;
    private InetAddress _host;
    private int _port;
    private DataOutputStream _dataos;
    private CommandToNet c2n = new CommandToNet(true);
    private MultiplexReader _reader;
    private Worker _worker;
    private Stack _runners = new Stack();
    private MultiplexSocketFactory _factory;
    public static final byte CMD_NEW = 1;
    public static final byte CMD_CLOSE = 2;
    public static final byte CMD_DATA = 3;
    public static final byte CMD_HELLO = 4;
    public static final byte CMD_BYE = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexSocket(MultiplexSocketFactory multiplexSocketFactory, InetAddress inetAddress, int n, int n2) throws IOException {
        super(inetAddress, n);
        this._factory = multiplexSocketFactory;
        this._channel = new MultiplexConnectionFactory[n2];
        this._capacity = n2;
        this._host = inetAddress;
        this._port = n;
        this._worker = new Worker(2);
        Closeable closeable = this._dataos = new DataOutputStream(new BufferedOutputStream(this.getOutputStream()));
        synchronized (closeable) {
            this._dataos.writeByte(4);
            this._dataos.writeByte(3);
            this._dataos.writeByte(0);
            this._dataos.flush();
        }
        closeable = new DataInputStream(new BufferedInputStream(this.getInputStream()));
        this._reader = new MultiplexReader(this, (DataInputStream)closeable);
        this._reader.start();
    }

    private InputRunner getRunner(ConnectionFactory connectionFactory, CommandData commandData) {
        InputRunner inputRunner = null;
        try {
            inputRunner = (InputRunner)this._runners.pop();
            inputRunner.initialize(connectionFactory, commandData);
        }
        catch (EmptyStackException emptyStackException) {
            inputRunner = new InputRunner(connectionFactory, commandData);
        }
        return inputRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MultiplexConnectionFactory createChannel(InetAddress inetAddress, int n, Properties properties) throws IOException {
        for (int i = 0; i < this._capacity; ++i) {
            MultiplexConnectionFactory multiplexConnectionFactory;
            int n2 = (i + this._lastIndex) % this._capacity;
            if (this._channel[n2] != null) continue;
            this._channel[n2] = multiplexConnectionFactory = new MultiplexConnectionFactory(n2, this, properties);
            this._lastIndex = n2 + 1;
            ++this._numChannels;
            DataOutputStream dataOutputStream = this._dataos;
            synchronized (dataOutputStream) {
                try {
                    this._dataos.write(1);
                    this._dataos.writeInt(n2);
                    this._dataos.write(inetAddress.getAddress());
                    this._dataos.flush();
                }
                catch (IOException iOException) {
                    --this._numChannels;
                    this._channel[n2] = null;
                    throw iOException;
                }
            }
            return multiplexConnectionFactory;
        }
        return null;
    }

    public boolean isPrettyFull() {
        return this._numChannels * 2 > this._capacity;
    }

    public boolean matches(InetAddress inetAddress, int n) {
        return this._port == n && inetAddress.equals(this._host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.writeByte(5);
            this._dataos.flush();
        }
        this._dataos.close();
        this._reader.shutdown();
        try {
            this._reader.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._worker.stop();
        this._runners.clear();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) throws IOException {
        this.deleteChannel(n);
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.write(2);
            this._dataos.writeInt(n);
            this._dataos.flush();
        }
    }

    private synchronized void deleteChannel(int n) {
        this._channel[n] = null;
        --this._numChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommand(int n, CommandData commandData) throws IOException {
        DataOutputStream dataOutputStream = this._dataos;
        synchronized (dataOutputStream) {
            this._dataos.write(3);
            this._dataos.writeInt(n);
            this.c2n.sendCommand(this._dataos, commandData);
        }
    }

    class MultiplexReader
    extends Thread {
        private DataInputStream _datais;
        private boolean _shutdown = false;
        MultiplexSocket _socket;

        public MultiplexReader(MultiplexSocket multiplexSocket2, DataInputStream dataInputStream) {
            this._datais = dataInputStream;
            this._socket = multiplexSocket2;
        }

        public void shutdown() {
            this._shutdown = true;
        }

        public void run() {
            block10: while (!this._shutdown) {
                int n;
                try {
                    n = this._datais.readByte();
                    switch (n) {
                        case 3: {
                            int n2 = this._datais.readInt();
                            CommandData commandData = MultiplexSocket.this.c2n.readCommand(this._datais);
                            if (MultiplexSocket.this._channel[n2] != null) {
                                InputRunner inputRunner = MultiplexSocket.this.getRunner(MultiplexSocket.this._channel[n2], commandData);
                                MultiplexSocket.this._worker.addRunnable(inputRunner);
                                continue block10;
                            }
                            System.err.println("received data " + Command.toString(commandData) + " for non-existant channel " + n2);
                            continue block10;
                        }
                        case 2: {
                            int n2 = this._datais.readInt();
                            if (MultiplexSocket.this._channel[n2] == null) continue block10;
                            MultiplexSocket.this._channel[n2].closed("Connection closed by server");
                            MultiplexSocket.this.deleteChannel(n2);
                            continue block10;
                        }
                        case 5: {
                            int n2;
                            for (n2 = 0; n2 < MultiplexSocket.this._channel.length; ++n2) {
                                if (MultiplexSocket.this._channel[n2] == null) continue;
                                MultiplexSocket.this._channel[n2].closed("Connection closed by server");
                                MultiplexSocket.this.deleteChannel(n2);
                            }
                            this._shutdown = true;
                            continue block10;
                        }
                        case 4: {
                            byte by = this._datais.readByte();
                            byte by2 = this._datais.readByte();
                            continue block10;
                        }
                    }
                    System.err.println("Unexpected command " + n);
                }
                catch (Exception exception) {
                    MultiplexSocket.this._factory.remove(this._socket);
                    for (n = 0; n < MultiplexSocket.this._channel.length; ++n) {
                        if (MultiplexSocket.this._channel[n] == null) continue;
                        MultiplexSocket.this._channel[n].closed(exception.toString());
                    }
                    this._shutdown = true;
                    break;
                }
            }
            try {
                this._datais.close();
                this._datais = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class InputRunner
    implements Runnable {
        private CommandData _cd;
        private ConnectionFactory _cf;

        InputRunner(ConnectionFactory connectionFactory, CommandData commandData) {
            this._cd = commandData;
            this._cf = connectionFactory;
        }

        void initialize(ConnectionFactory connectionFactory, CommandData commandData) {
            this._cd = commandData;
            this._cf = connectionFactory;
        }

        public void run() {
            this._cf.handleCommand(this._cd);
            MultiplexSocket.this._runners.push(this);
        }
    }
}

