/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public abstract class Message
implements Serializable {
    static final long serialVersionUID = -6972605931843726119L;
    static long lastTime = 0L;
    static int lastTimeIndex = 0;
    static Object timeLock = new Object();
    static Locale defaultLocale = Locale.getDefault();
    protected String msgid;
    protected Destination from = null;
    protected Destination[] to = null;
    protected Date creationDate = new Date();
    protected Date expireDate = null;
    protected Date futureSendDate = null;
    protected String contentType = new String("net/html");
    protected String lang = Locale.getDefault().toString();
    protected String subject = "no subject";
    protected Object body = null;
    protected transient boolean markRead = false;
    public static final String ID_BODY = "BODY";
    private static final String ID_FILES = "FILES";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message() {
        long l = System.currentTimeMillis();
        int n = 0;
        Object object = timeLock;
        synchronized (object) {
            if (lastTime == l) {
                n = ++lastTimeIndex;
            } else {
                lastTime = l;
                lastTimeIndex = 0;
            }
        }
        this.msgid = "iim." + ConnectionFactory.processId + "." + Long.toString(l) + "." + n;
        this.setLocale(defaultLocale);
    }

    public void markRead() {
        this.markRead = true;
    }

    public boolean isMarkedRead() {
        return this.markRead;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public Destination getFrom() {
        return this.from;
    }

    public void setFrom(Destination destination) {
        this.from = destination;
    }

    public void setTo(Destination[] destinationArray) {
        this.to = destinationArray;
    }

    public void addTo(Destination destination) {
        if (this.to == null || this.to.length == 0) {
            this.to = new Destination[1];
            this.to[0] = destination;
        } else {
            Destination[] destinationArray = new Destination[this.to.length + 1];
            System.arraycopy(this.to, 0, destinationArray, 0, this.to.length);
            destinationArray[this.to.length] = destination;
            this.to = destinationArray;
        }
    }

    public Destination[] getTo() {
        return this.to;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object object) {
        this.body = object;
    }

    public void setText(String string) {
        String string2 = this.getContentType();
        if (string2.equals("net/htmlex")) {
            Hashtable hashtable = (Hashtable)this.getBody();
            hashtable.put(ID_BODY, string);
        } else if (string2.equals("net/url")) {
            try {
                this.body = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (string2.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)this.getBody();
            try {
                hashtable.put(ID_BODY, new URL(string));
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (string2.equals("net/chatex") || string2.equals("net/invite")) {
            Object[] objectArray = (Object[])this.getBody();
            objectArray[0] = string;
        } else {
            this.body = string;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date date) {
        this.expireDate = date;
    }

    public Date getFutureSendDate() {
        return this.futureSendDate;
    }

    public void setFutureSendDate(Date date) {
        this.futureSendDate = date;
    }

    public String getMsgid() {
        return this.msgid;
    }

    public void setMsgid(String string) {
        this.msgid = string;
    }

    public String toString() {
        return Message.toString(this);
    }

    public static final String toString(Message message) {
        if (message == null) {
            return null;
        }
        String string = message.getContentType();
        if (string.equals("net/html")) {
            return (String)message.getBody();
        }
        if (string.equals("net/htmlex")) {
            Hashtable hashtable = (Hashtable)message.getBody();
            return (String)hashtable.get(ID_BODY);
        }
        if (string.equals("net/text")) {
            return (String)message.getBody();
        }
        if (string.equals("net/url")) {
            return ((URL)message.getBody()).toString();
        }
        if (string.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)message.getBody();
            return ((URL)hashtable.get(ID_BODY)).toString();
        }
        if (string.equals("net/reply")) {
            return "Reply: " + (String)message.getBody();
        }
        if (string.equals("net/chat")) {
            return (String)message.getBody();
        }
        if (string.equals("net/chatex")) {
            Object[] objectArray = (Object[])message.getBody();
            return (String)objectArray[0];
        }
        if (string.equals("net/typing")) {
            return "Typing";
        }
        if (string.equals("net/typing_off")) {
            return "Typing-Off";
        }
        if (string.equals("net/wb")) {
            return "WhiteBoard";
        }
        if (string.equals("net/wb")) {
            return "WhiteBoard Invite";
        }
        if (string.equals("net/invite")) {
            Object[] objectArray = (Object[])message.getBody();
            return (String)objectArray[0];
        }
        if (string.equals("net/poll")) {
            StringBuffer stringBuffer = new StringBuffer("Poll: " + message.getSubject());
            Hashtable hashtable = (Hashtable)message.getBody();
            Vector vector = (Vector)hashtable.get(ID_BODY);
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append("\n");
                stringBuffer.append((String)vector.elementAt(i));
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
        if (string.equals("net/pollreply")) {
            return "Poll reply: " + (String)message.getBody();
        }
        return message.getBody().toString();
    }

    public Map getAttachments() {
        return Message.getAttachments(this);
    }

    public static Map getAttachments(Message message) {
        String string = message.getContentType();
        if (string.equals("net/htmlex") || string.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)message.getBody();
            return (Hashtable)hashtable.get(ID_FILES);
        }
        if (string.equals("net/chatex") || string.equals("net/invite")) {
            Object[] objectArray = (Object[])message.getBody();
            if (objectArray.length > 3 && objectArray[2] != null && objectArray[3] != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
                hashMap.put((String)objectArray[2], objectArray[3]);
                return hashMap;
            }
            return null;
        }
        return null;
    }

    public void printAttachments() {
        Object[] objectArray;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)this.body;
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (objectArray = (Object[])this.body).length > 2 && objectArray[2] != null) {
            System.out.println((String)objectArray[2]);
        }
    }

    public void addAttachment(String string, byte[] byArray) {
        Object[] objectArray;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)this.body;
            Hashtable hashtable2 = (Hashtable)hashtable.get(ID_FILES);
            hashtable2.put(string, byArray);
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (objectArray = (Object[])this.body).length > 3) {
            objectArray[2] = string;
            objectArray[3] = byArray;
        }
    }

    public void renameAttachment(String string, String string2) {
        Object[] objectArray;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)this.body;
            Hashtable hashtable2 = (Hashtable)hashtable.get(ID_FILES);
            Object v = hashtable2.remove(string);
            if (v != null) {
                hashtable2.put(string2, v);
            }
        } else if ((this.contentType.equals("net/chatex") || this.contentType.equals("net/invite")) && (objectArray = (Object[])this.body).length > 2) {
            objectArray[2] = string2;
        }
    }

    public void removeAttachment(String string) {
        Object[] objectArray;
        if (this.contentType.equals("net/htmlex") || this.contentType.equals("net/urlex")) {
            Hashtable hashtable = (Hashtable)this.body;
            Hashtable hashtable2 = (Hashtable)hashtable.get(ID_FILES);
            hashtable2.remove(string);
        } else if (this.contentType.equals("net/chatex")) {
            this.contentType = "net/chat";
            Object[] objectArray2 = (Object[])this.body;
            this.body = objectArray2[0];
        } else if (this.contentType.equals("net/invite") && (objectArray = (Object[])this.body).length > 3) {
            objectArray[2] = null;
            objectArray[3] = null;
        }
    }

    public void setLocale(Locale locale) {
        this.lang = locale.toString();
    }

    public String getLangTag() {
        return this.lang;
    }
}

