/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMRealm;
import com.iplanet.im.net.iIMUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class DestinationAccessControlList
implements Serializable {
    static final long serialVersionUID = 8496595709808651411L;
    public static final int NONE = 1;
    public static final int READ = 2;
    public static final int LISTEN = 2;
    public static final int WRITE = 6;
    public static final int SPEAK = 6;
    public static final int VIEW = 6;
    public static final int MANAGE = 14;
    public static final int FULL = 14;
    private Vector v = new Vector();
    private int defaultAccess = 1;

    public void setDefault(int n) {
        this.defaultAccess = n;
    }

    public int getDefault() {
        return this.defaultAccess;
    }

    public Enumeration entries() {
        return new EntryEnum();
    }

    private Entry findEntry(iIMPrincipal iIMPrincipal2) {
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            iIMPrincipal iIMPrincipal3 = entry.p;
            if (iIMPrincipal2 instanceof iIMUser && iIMPrincipal3 instanceof iIMUser && iIMPrincipal2.getUID().equals(iIMPrincipal3.getUID())) {
                return entry;
            }
            if (!(iIMPrincipal2 instanceof iIMGroup) || !(iIMPrincipal3 instanceof iIMGroup) || !iIMPrincipal2.getUID().equals(iIMPrincipal3.getUID())) continue;
            return entry;
        }
        return null;
    }

    private Collection getGroups() {
        ArrayList<iIMPrincipal> arrayList = new ArrayList<iIMPrincipal>();
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            iIMPrincipal iIMPrincipal2 = entry.p;
            if (!(iIMPrincipal2 instanceof iIMGroup)) continue;
            arrayList.add(iIMPrincipal2);
        }
        return arrayList;
    }

    public void add(iIMPrincipal iIMPrincipal2, int n) {
        Entry entry = this.findEntry(iIMPrincipal2);
        if (entry == null) {
            this.v.addElement(new Entry(iIMPrincipal2, n));
        }
    }

    public void remove(iIMPrincipal iIMPrincipal2) {
        Entry entry = this.findEntry(iIMPrincipal2);
        if (entry != null) {
            this.v.removeElement(entry);
        }
    }

    public void removeAll() {
        this.v.removeAllElements();
    }

    public int getAccess(iIMPrincipal iIMPrincipal2) {
        Entry entry = this.findEntry(iIMPrincipal2);
        if (entry == null) {
            return this.defaultAccess;
        }
        return entry.access;
    }

    public int getAccess(iIMPrincipal iIMPrincipal2, iIMRealm iIMRealm2) {
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            iIMPrincipal iIMPrincipal3 = entry.p;
            if (iIMPrincipal2 instanceof iIMUser && iIMPrincipal3 instanceof iIMUser && iIMPrincipal2.getUID().equals(iIMPrincipal3.getUID())) {
                return entry.access;
            }
            if (iIMPrincipal2 instanceof iIMGroup && iIMPrincipal3 instanceof iIMGroup && iIMPrincipal2.getUID().equals(iIMPrincipal3.getUID())) {
                return entry.access;
            }
            if (!(iIMPrincipal2 instanceof iIMUser) || !(iIMPrincipal3 instanceof iIMGroup) || !iIMRealm2.isMemberOfGroup(iIMPrincipal2, (iIMGroup)iIMPrincipal3)) continue;
            return entry.access;
        }
        return this.defaultAccess;
    }

    class EntryEnum
    implements Enumeration {
        Enumeration e;

        public EntryEnum() {
            Vector vector = (Vector)DestinationAccessControlList.this.v.clone();
            this.e = vector.elements();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            Entry entry = (Entry)this.e.nextElement();
            return entry.p;
        }
    }

    class Entry
    implements Serializable {
        iIMPrincipal p;
        int access;

        Entry(iIMPrincipal iIMPrincipal2, int n) {
            this.p = iIMPrincipal2;
            this.access = n;
        }
    }
}

