/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessagePartImpl;
import com.iplanet.im.net.QueueMsg;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.MessagePart;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.ReadOnlyMessagePart;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseMessageImpl
extends MessagePartImpl
implements ReadOnlyMessage {
    HashMap _props = new HashMap();
    private ArrayList _parts = new ArrayList(1);

    public BaseMessageImpl(Message message) {
        super(message);
        this._message = message;
        this._parent = this;
        this.loadParts();
    }

    public BaseMessageImpl() {
    }

    public String getOriginator() {
        return this._message.getFrom().getUID();
    }

    public String getMessageId() {
        return this._message.getMsgid();
    }

    public Date getExpirationDate() {
        return this._message.getExpireDate();
    }

    public String getContentType() {
        return BaseMessageImpl.getContentType(this._message);
    }

    protected static String getContentType(Message message) {
        String string = message.getContentType();
        if (string.equals("net/text")) {
            return "text/plain";
        }
        if (string.equals("net/html")) {
            return "text/html";
        }
        if (string.equals("net/chat")) {
            return "text/html";
        }
        if (string.equals("net/chatex")) {
            return "text/html";
        }
        if (string.equals("net/invite")) {
            return "text/html";
        }
        if (string.equals("net/url")) {
            return "text/url";
        }
        if (string.equals("net/urlex")) {
            return "text/url";
        }
        if (string.equals("net/htmlex")) {
            return "text/html";
        }
        if (string.equals("net/poll")) {
            return "application/x-iim-poll";
        }
        if (string.equals("net/pollreply")) {
            return "application/x-iim-poll-reply";
        }
        return string;
    }

    public String getHeader(String string) {
        if (string.equalsIgnoreCase("subject")) {
            return this._message.getSubject();
        }
        if (this._message instanceof QueueMsg && string.equalsIgnoreCase("related-message-id")) {
            return ((QueueMsg)this._message).getCorrelationMsgId();
        }
        return (String)this._props.get(string.toLowerCase());
    }

    public void setHeader(String string, String string2) {
        if (string.equalsIgnoreCase("subject")) {
            this._message.setSubject(string2);
        }
        this._props.put(string.toLowerCase(), string2);
    }

    public String[] getRecipients() throws CollaborationException {
        Destination[] destinationArray = this._message.getTo();
        String[] stringArray = new String[destinationArray.length];
        for (int i = 0; i < destinationArray.length; ++i) {
            stringArray[i] = destinationArray[i].getFQName();
        }
        return stringArray;
    }

    private void loadParts() {
        this._parts.add(this);
        Map map = this._message.getAttachments();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[] byArray = (byte[])map.get(string);
                this._parts.add(new MessagePartImpl(this, this._message, string, byArray));
            }
        }
    }

    public MessagePart[] getParts() {
        MessagePart[] messagePartArray = new MessagePart[this._parts.size()];
        int n = 0;
        Iterator iterator = this._parts.iterator();
        while (iterator.hasNext()) {
            messagePartArray[n++] = (MessagePart)iterator.next();
        }
        return messagePartArray;
    }

    public List getPartsAsList() {
        return this._parts;
    }

    public ReadOnlyMessagePart[] getReadOnlyParts() {
        return this.getParts();
    }

    public void addPart(MessagePart messagePart) throws CollaborationException {
        String string = this._message.getContentType();
        if (messagePart != this) {
            Hashtable<String, byte[]> hashtable = this._message.getAttachments();
            if (hashtable == null) {
                Hashtable<String, Hashtable<String, byte[]>> hashtable2;
                if (string.equals("net/htmlex") || string.equals("net/urlex") || string.equals("net/chatex")) {
                    hashtable2 = (Hashtable<String, Hashtable<String, byte[]>>)this._message.getBody();
                } else if (string.equals("net/html")) {
                    this._message.setContentType("net/htmlex");
                    hashtable2 = new Hashtable<String, Hashtable<String, byte[]>>(3);
                    hashtable2.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else if (string.equals("net/chat")) {
                    this._message.setContentType("net/chatex");
                    hashtable2 = new Hashtable(3);
                    hashtable2.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else if (string.equals("net/url")) {
                    this._message.setContentType("net/urlex");
                    hashtable2 = new Hashtable(3);
                    hashtable2.put("BODY", (Hashtable<String, byte[]>)((Object)this._sContent));
                } else {
                    throw new CollaborationException("Cannot add part to message of content-tupe " + string);
                }
                hashtable = new Hashtable<String, byte[]>(3);
                hashtable2.put("FILES", hashtable);
            }
            hashtable.put(messagePart.getContentName(), ((MessagePartImpl)messagePart).getBytes());
        }
    }

    public void removePart(MessagePart messagePart) throws CollaborationException {
        Map map;
        if (messagePart.getContentType().equalsIgnoreCase("application/octet-stream") && (map = this._message.getAttachments()) != null) {
            map.remove(messagePart.getContentName());
        }
    }
}

