/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api.test;

import com.iplanet.im.client.api.test.NoSuchConferenceException;
import com.iplanet.im.client.api.test.iimtalk;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.Message;
import java.util.ArrayList;

public class iIMCLIConference
implements ConferenceListener {
    String _uid = null;
    String _name;
    Conference _conf;
    ConferenceSession _confSession;
    boolean _private = true;

    public iIMCLIConference(String uid, ConferenceSession s, String name, boolean create, boolean join) throws Exception {
        this._uid = uid;
        this._confSession = s;
        this._conf = create ? s.setupPublicConference(name, this, 30) : (join ? s.joinPublicConference(name, this) : s.getPublicConference(name));
        if (this._conf == null) {
            throw new NoSuchConferenceException("Conference " + name + " does not exist");
        }
        this._name = this._conf.getDestination();
        this._private = false;
    }

    public iIMCLIConference(String uid, ConferenceSession s) throws Exception {
        this._uid = uid;
        this._confSession = s;
        this._conf = s.setupConference(this, 30);
        this._name = this._conf.getDestination();
        if (!this._name.startsWith(".")) {
            this._private = false;
        }
    }

    public iIMCLIConference(String uid, ConferenceSession s, Conference c) throws Exception {
        this._uid = uid;
        this._confSession = s;
        this._conf = c;
        c.join(this);
        this._name = this._conf.getDestination();
        if (!this._name.startsWith(".")) {
            this._private = false;
        }
    }

    public iIMCLIConference(String uid, String name) throws Exception {
        this._uid = uid;
        this._name = name;
        if (!this._name.startsWith(".")) {
            this._private = false;
        }
    }

    public void onMessageAdded(Message message) {
        if (this._private) {
            System.out.println("[" + this._uid + ":chat] message added -- " + message.getHeader("subject"));
        } else {
            System.out.println("[" + this._uid + ":" + this._name + "] message added -- " + message.getHeader("subject"));
        }
        iimtalk.printMessage(message);
    }

    public void onEvent(String event) {
        ConferenceEventHelper ch = null;
        try {
            ch = new ConferenceEventHelper(event.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList tuples = (ArrayList)ch.getTuples();
        for (int i = 0; i < tuples.size(); ++i) {
            ConferenceEventTuple t = (ConferenceEventTuple)tuples.get(i);
            try {
                System.out.println("\n[ConferenceEvent Received] Recipient=<" + this._confSession.getPrincipal().getUID() + "> Destination=<" + t.destination + "> status=<" + t.status + ">");
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception: " + e);
                break;
            }
        }
    }

    public void onError(CollaborationException e) {
    }

    public Conference getConference() {
        return this._conf;
    }

    public void onModeratedMessageAdded(Message message) {
    }

    public void onModeratedMessageStatus(Message message, int status, String reason) {
    }
}

