/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMSession;
import com.sun.im.service.ApplicationInfo;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.CollaborationSessionProvider;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.util.Worker;
import java.security.Principal;
import java.util.Hashtable;

public class iIMSessionFactory
implements CollaborationSessionProvider {
    Hashtable _sessions = new Hashtable();
    Worker _worker = new Worker(concurrency);
    public static final String debugPropertyName = "com.iplanet.im.client.api.debug";
    public static final String concurrencyName = "com.iplanet.im.client.api.concurrency";
    private static boolean verbose = false;
    private static int concurrency = 2;

    protected void addRunnable(Runnable r) {
        this._worker.addRunnable(r);
    }

    public CollaborationSession getSession(Principal principal, CollaborationSessionListener listener) throws CollaborationException {
        throw new CollaborationException("Not implemented");
    }

    public CollaborationSession getSession(String uid, CollaborationSessionListener listener) throws CollaborationException {
        throw new CollaborationException("Not implemented");
    }

    public CollaborationSession getSession(String serviceUrl, String loginName, String password, CollaborationSessionListener listener) throws CollaborationException {
        return this.getSession(serviceUrl, loginName, password, 1, listener);
    }

    CollaborationSession getSession(String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener) throws CollaborationException {
        String sid = loginName + "[" + serviceUrl + "]";
        try {
            iIMSession s = (iIMSession)this._sessions.get(sid);
            if (s == null) {
                s = new iIMSession(this, serviceUrl, loginName, password, loginType, listener);
                this._sessions.put(sid, s);
            } else {
                s.setSessionListener(listener);
            }
            return s;
        }
        catch (CollaborationException e) {
            this._sessions.remove(sid);
            throw e;
        }
    }

    CollaborationSession getExistingSession(String serviceUrl, String loginName) throws CollaborationException {
        return (iIMSession)this._sessions.get(loginName + "[" + serviceUrl + "]");
    }

    CollaborationSession refreshSession(String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener) throws CollaborationException {
        iIMSession s = (iIMSession)this.getExistingSession(serviceUrl, loginName);
        if (s != null) {
            s.logout();
        }
        return (iIMSession)this.getSession(serviceUrl, loginName, password, loginType, listener);
    }

    protected void removeSession(iIMSession s) {
        String key = s.getUserId() + "[" + s.getServiceUrl() + "]";
        this._sessions.remove(key);
    }

    protected static void debug(String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    public void close() {
        this._worker.stop();
    }

    public void register(String serviceURL, RegistrationListener listener) throws CollaborationException {
    }

    public void setApplicationInfo(ApplicationInfo appinfo) throws CollaborationException {
    }

    public ApplicationInfo getApplicationInfo() throws CollaborationException {
        return null;
    }

    static {
        String s = System.getProperty(debugPropertyName);
        if (s != null) {
            verbose = true;
        }
        if ((s = System.getProperty(concurrencyName)) != null) {
            try {
                concurrency = Integer.parseInt(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

