/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMSession;
import com.sun.im.service.AccessRule;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import java.util.Collection;

public class iIMAccessRule
implements AccessRule {
    String _domain;
    String _resourceURL;
    boolean _grant;
    String _exceptDomain;
    Collection _principals;
    Collection _exceptPrincipals;
    iIMSession _session;

    public String getResourceURL() {
        return this._resourceURL;
    }

    public boolean grant() {
        return this._grant;
    }

    public void setGrant(boolean grant) {
        this._grant = grant;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getExceptDomain() {
        return this._exceptDomain;
    }

    public Collection getPrincipals() {
        return this._principals;
    }

    public Collection getExceptPrincipals() {
        return this._exceptPrincipals;
    }

    public iIMAccessRule(CollaborationSession session, boolean grant, String resourceURL, String domain, String exceptDomain, Collection exceptPrincipals) {
        this._session = (iIMSession)session;
        this._domain = domain;
        this._exceptDomain = exceptDomain;
        this._exceptPrincipals = exceptPrincipals;
        this._grant = grant;
        this._resourceURL = resourceURL;
    }

    public iIMAccessRule(CollaborationSession session, boolean grant, String resourceURL, String domain, Collection exceptPrincipals) {
        this._session = (iIMSession)session;
        this._domain = domain;
        this._exceptPrincipals = exceptPrincipals;
        this._resourceURL = resourceURL;
        this._grant = grant;
    }

    public iIMAccessRule(CollaborationSession session, boolean grant, String resourceURL, Collection principals, Collection exceptPrincipals) {
        this._session = (iIMSession)session;
        this._grant = grant;
        this._resourceURL = resourceURL;
    }

    public iIMAccessRule(CollaborationSession session, boolean grant, String resourceURL, Collection principals) {
        this._session = (iIMSession)session;
        this._principals = principals;
        this._grant = grant;
        this._resourceURL = resourceURL;
    }

    public void addPrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = this._session.createPrincipal(uid);
        this.addPrincipal(p);
    }

    public void addPrincipal(CollaborationPrincipal p) throws CollaborationException {
        if (this._principals == null) {
            throw new CollaborationException("Can't have both domain and principals");
        }
        if (!this._principals.contains(p)) {
            this._principals.add(p);
        }
    }

    public void removePrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = this._session.createPrincipal(uid);
        this._principals.remove(p);
    }

    public void removePrincipal(CollaborationPrincipal p) throws CollaborationException {
        this._principals.remove(p);
    }

    public void removeAllPrincipals() throws CollaborationException {
        this._principals.clear();
    }

    public void addExceptPrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = this._session.createPrincipal(uid);
        this.addExceptPrincipal(p);
    }

    public void addExceptPrincipal(CollaborationPrincipal p) throws CollaborationException {
        if (!this._exceptPrincipals.contains(p)) {
            this._exceptPrincipals.add(p);
        }
    }

    public void removeExceptPrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = this._session.createPrincipal(uid);
        this.removeExceptPrincipal(p);
    }

    public void removeExceptPrincipal(CollaborationPrincipal p) throws CollaborationException {
        this._exceptPrincipals.remove(p);
    }

    public void removeAllExceptPrincipals() throws CollaborationException {
        this._exceptPrincipals.clear();
    }
}

