/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.x.core;

import java.util.HashMap;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.features.AbstractFeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.util.IdentityGenerator;
import org.jabberstudio.jso.util.PacketException;
import org.jabberstudio.jso.util.XPathListener;
import org.jabberstudio.jso.x.core.SessionQuery;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.saxpath.SAXPathException;

public class SessionFeatureConsumer
extends AbstractFeatureConsumer {
    private boolean _StrictNS;

    public SessionFeatureConsumer() {
        this(true);
    }

    public SessionFeatureConsumer(boolean strict) {
        this._StrictNS = strict;
    }

    public boolean isStrict() {
        return this._StrictNS;
    }

    public void setStrict(boolean strict) {
        this._StrictNS = strict;
    }

    public StreamFeature findFeature(StreamFeatureset fs) {
        return (StreamFeature)(this.isStrict() ? fs.getFirstElement(SessionQuery.NAME) : fs.getFirstElement(SessionQuery.NAME.getLocalName()));
    }

    protected void startConsumption() throws IllegalStateException, StreamException {
        SessionWatcher watch;
        FeatureContext ctx = this.getFeatureContext();
        PacketRouter router = ctx.getRouter();
        PacketDispatcher dispatch = ctx.getDispatcher();
        StreamDataFactory sdf = ctx.getRouter().getDataFactory();
        try {
            watch = new SessionWatcher(router);
            dispatch.addPacketListener(PacketEvent.RECEIVED, watch);
        }
        catch (SAXPathException spe) {
            throw new IllegalStateException("Could not register Session packet listener");
        }
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(sdf.createNSI("iq", router.getDefaultNamespace()), InfoQuery.class);
        iq.setType(InfoQuery.SET);
        iq.setID(IdentityGenerator.generateGlobal("session"));
        SessionQuery session = (SessionQuery)iq.addElement(SessionQuery.NAME, SessionQuery.class);
        ((SimpleVariableContext)watch.getXPath().getVariableContext()).setVariableValue("id", (Object)iq.getID());
        router.send(iq);
    }

    private class SessionWatcher
    extends XPathListener {
        public SessionWatcher(PacketRouter router) throws SAXPathException {
            super(router.getDataFactory(), "app:iq[(@id=$id) and ((@type='result') or (@type='error'))]");
            HashMap<String, String> nss = new HashMap<String, String>();
            nss.put("app", router.getDefaultNamespace());
            nss.put("auth", "jabber:iq:auth");
            this.setupNamespaces(nss);
            this.getXPath().setVariableContext((VariableContext)new SimpleVariableContext());
        }

        public void packetMatched(PacketEvent evt) {
            PacketDispatcher dispatch = SessionFeatureConsumer.this.getFeatureContext().getDispatcher();
            InfoQuery iq = (InfoQuery)evt.getData();
            dispatch.removePacketListener(PacketEvent.RECEIVED, this);
            if (iq.getType() == InfoQuery.ERROR) {
                SessionFeatureConsumer.this.completeFailedConsumption(new PacketException(iq.getError()));
            } else {
                SessionFeatureConsumer.this.completeSucceededConsumption(false);
            }
        }
    }
}

