/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.x.core;

import java.util.HashMap;
import java.util.Map;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.features.AbstractFeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.util.IdentityGenerator;
import org.jabberstudio.jso.util.PacketException;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.util.XPathListener;
import org.jabberstudio.jso.x.core.AuthQuery;
import org.jabberstudio.jso.x.core.AuthStreamFeature;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.saxpath.SAXPathException;

public class AuthFeatureConsumer
extends AbstractFeatureConsumer {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_AUTH = 1;
    private static final int STATE_SUCCEEDED = 2;
    private static final int STATE_FAILED = -1;
    private JID _Srv;
    private String _Usr;
    private String _Pwd = "";
    private String _Res;
    static /* synthetic */ Class class$org$jabberstudio$jso$x$core$AuthStreamFeature;

    public AuthFeatureConsumer() {
    }

    public AuthFeatureConsumer(JID srv, String usr, String pwd, String res) throws IllegalArgumentException {
        this.setServer(srv);
        this.setUsername(usr);
        this.setPassword(pwd);
        this.setResource(res);
    }

    public JID getServer() {
        return this._Srv;
    }

    public void setServer(JID srv) {
        this._Srv = srv;
    }

    public String getUsername() {
        return this._Usr;
    }

    public void setUsername(String usr) throws IllegalArgumentException {
        if (!Utilities.isValidString(usr) || !JID.isValidNode(usr)) {
            throw new IllegalArgumentException("String \"" + usr + "\" is not a valid username");
        }
        this._Usr = usr;
    }

    public String getPassword() {
        return this._Pwd;
    }

    public void setPassword(String pwd) {
        this._Pwd = pwd != null ? pwd : "";
    }

    public String getResource() {
        return this._Res;
    }

    public void setResource(String res) throws IllegalArgumentException {
        if (!Utilities.isValidString(res) || !JID.isValidResource(res)) {
            throw new IllegalArgumentException("String \"" + res + "\" is not a valid resource");
        }
        this._Res = res;
    }

    public void authenticate(PacketRouter router, PacketDispatcher dispatch) throws IllegalArgumentException, IllegalStateException, StreamException, PacketException {
        Context ctx = new Context(router, dispatch);
        this.setFeatureContext(ctx);
        try {
            this.startAuth(router, dispatch);
        }
        catch (Throwable t) {
            ctx.completeFailed(t);
        }
        try {
            while (ctx.isRunning()) {
                router.process();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {}
            }
        }
        catch (StreamException se) {
            ctx.completeFailed(se);
        }
        Throwable cause = ctx.getFailure();
        if (cause != null) {
            if (cause instanceof StreamException) {
                throw (StreamException)cause;
            }
            if (cause instanceof PacketException) {
                throw (PacketException)cause;
            }
            if (cause instanceof IllegalStateException) {
                throw (IllegalArgumentException)cause;
            }
            PacketException pe = new PacketException(PacketError.CANCEL, "undefined-condition");
            pe.initCause(cause);
            throw pe;
        }
    }

    public StreamFeature findFeature(StreamFeatureset fs) {
        return (StreamFeature)fs.getFirstElement(AuthStreamFeature.NAME);
    }

    protected void startConsumption() throws Throwable {
        FeatureContext ctx = this.getFeatureContext();
        PacketRouter router = ctx.getRouter();
        PacketDispatcher dispatch = ctx.getDispatcher();
        this.startAuth(router, dispatch);
    }

    private void startAuth(PacketRouter router, PacketDispatcher dispatch) throws IllegalStateException, StreamException {
        AuthWatcher watch;
        StreamDataFactory sdf = router.getDataFactory();
        String usr = this.getUsername();
        String res = this.getResource();
        if (!Utilities.isValidString(usr)) {
            throw new IllegalStateException("username is not valid");
        }
        if (!Utilities.isValidString(res)) {
            throw new IllegalStateException("resource is not valid");
        }
        try {
            watch = new AuthWatcher(router);
            dispatch.addPacketListener(PacketEvent.RECEIVED, watch);
        }
        catch (SAXPathException spe) {
            throw new IllegalStateException("Could not register Auth packet listener");
        }
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(sdf.createNSI("iq", router.getDefaultNamespace()), InfoQuery.class);
        iq.setID(IdentityGenerator.generateGlobal("auth"));
        iq.setTo(this.getServer());
        iq.setType(InfoQuery.GET);
        AuthQuery auth = (AuthQuery)iq.addElement(AuthQuery.NAME, AuthQuery.class);
        auth.setUsername(usr);
        auth.setResource(res);
        ((SimpleVariableContext)watch.getXPath().getVariableContext()).setVariableValue("id", (Object)iq.getID());
        router.send(iq);
    }

    protected AuthQuery configureAuth(PacketRouter r, AuthQuery in) throws PacketException {
        AuthQuery out = null;
        if (AuthQuery.DIGEST.isSupported(in)) {
            out = this.configureDigestAuth(r, in);
        } else if (AuthQuery.PLAIN.isSupported(in)) {
            out = this.configurePlainAuth(r, in);
        }
        if (out == null) {
            throw new PacketException(PacketError.CANCEL, "not-acceptable");
        }
        return out;
    }

    private final AuthQuery configureDigestAuth(PacketRouter r, AuthQuery in) {
        AuthQuery.Method method = AuthQuery.DIGEST;
        AuthQuery out = (AuthQuery)in.copy();
        Map params = method.setupAuthParams(out);
        String pass = this.getPassword();
        params.put("sessionid", r.getInboundContext().getID());
        params.put("password", pass);
        method.setupAuth(out, params);
        return out;
    }

    private final AuthQuery configurePlainAuth(PacketRouter r, AuthQuery in) {
        AuthQuery.Method method = AuthQuery.PLAIN;
        AuthQuery out = (AuthQuery)in.copy();
        Map params = method.setupAuthParams(out);
        String pass = this.getPassword();
        params.put("password", pass);
        method.setupAuth(out, params);
        return out;
    }

    private class AuthWatcher
    extends XPathListener {
        private PacketRouter _Router;
        private int _CurrState;

        public AuthWatcher(PacketRouter router) throws SAXPathException {
            super(router.getDataFactory(), "app:iq[(@id=$id) and ((@type='result') or (@type='error'))]");
            HashMap<String, String> nss = new HashMap<String, String>();
            nss.put("app", router.getDefaultNamespace());
            nss.put("auth", "jabber:iq:auth");
            this._Router = router;
            this.setupNamespaces(nss);
            this.setCurrentState(0);
            this.getXPath().setVariableContext((VariableContext)new SimpleVariableContext());
        }

        public PacketRouter getRouter() {
            return this._Router;
        }

        public int getCurrentState() {
            return this._CurrState;
        }

        public void setCurrentState(int state) {
            this._CurrState = state;
        }

        public void packetMatched(PacketEvent evt) {
            PacketDispatcher dispatch = AuthFeatureConsumer.this.getFeatureContext().getDispatcher();
            InfoQuery iq = (InfoQuery)evt.getData();
            if (iq.getType() == InfoQuery.ERROR) {
                this.setCurrentState(-1);
                AuthFeatureConsumer.this.completeFailedConsumption(new PacketException(iq.getError()));
            } else {
                switch (this.getCurrentState()) {
                    case 0: {
                        this.authStarted(iq);
                        break;
                    }
                    case 1: {
                        this.authSucceeded(iq);
                        break;
                    }
                    default: {
                        AuthFeatureConsumer.this.completeFailedConsumption(new IllegalStateException("unexpected auth state"));
                    }
                }
            }
            if (this.getCurrentState() == -1 || this.getCurrentState() == 2) {
                dispatch.removePacketListener(this);
            }
        }

        protected void authStarted(InfoQuery iq) {
            PacketRouter router = this.getRouter();
            StreamDataFactory sdf = router.getDataFactory();
            try {
                this.setCurrentState(1);
                AuthQuery auth = AuthFeatureConsumer.this.configureAuth(router, (AuthQuery)iq.getExtension(class$org$jabberstudio$jso$x$core$AuthQuery == null ? (class$org$jabberstudio$jso$x$core$AuthQuery = AuthFeatureConsumer.class$("org.jabberstudio.jso.x.core.AuthQuery")) : class$org$jabberstudio$jso$x$core$AuthQuery));
                auth.setUsername(AuthFeatureConsumer.this.getUsername());
                auth.setResource(AuthFeatureConsumer.this.getResource());
                iq = (InfoQuery)iq.copy();
                iq.reset();
                iq.setID(IdentityGenerator.generateGlobal("auth"));
                iq.setTo(AuthFeatureConsumer.this.getServer());
                iq.setType(InfoQuery.SET);
                iq.add(auth);
                ((SimpleVariableContext)this.getXPath().getVariableContext()).setVariableValue("id", (Object)iq.getID());
                router.send(iq);
            }
            catch (Throwable t) {
                this.setCurrentState(-1);
                AuthFeatureConsumer.this.completeFailedConsumption(t);
            }
        }

        protected void authSucceeded(InfoQuery iq) {
            this.setCurrentState(2);
            AuthFeatureConsumer.this.completeSucceededConsumption(false);
        }
    }

    private class Context
    implements FeatureContext {
        private StreamFeature _Feat;
        private PacketRouter _Router;
        private PacketDispatcher _Dispatch;
        private Throwable _Throw;
        private boolean _Running;

        public Context(PacketRouter r, PacketDispatcher d) {
            if (r == null) {
                throw new IllegalArgumentException("PacketRouter cannot be null");
            }
            if (d == null) {
                throw new IllegalArgumentException("PacketDispatcher cannot be null");
            }
            this._Router = r;
            this._Dispatch = d;
            this._Feat = (StreamFeature)r.getDataFactory().createElementNode(AuthStreamFeature.NAME, class$org$jabberstudio$jso$x$core$AuthStreamFeature == null ? (class$org$jabberstudio$jso$x$core$AuthStreamFeature = AuthFeatureConsumer.class$("org.jabberstudio.jso.x.core.AuthStreamFeature")) : class$org$jabberstudio$jso$x$core$AuthStreamFeature);
            this._Running = true;
        }

        public boolean isRunning() {
            return this._Running;
        }

        public Throwable getFailure() {
            return this._Throw;
        }

        public StreamFeature getFeature() {
            return this._Feat;
        }

        public PacketRouter getRouter() {
            return this._Router;
        }

        public PacketDispatcher getDispatcher() {
            return this._Dispatch;
        }

        public void completeFailed(Throwable t) {
            this._Throw = t;
            this._Running = false;
        }

        public void completeSucceeded(boolean restart) {
            this._Running = false;
        }
    }
}

