/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.Map;
import java.util.Set;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.xpath.XPathSupport;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class XPathListener
implements PacketListener {
    private PacketListener _Match;
    private XPath _XPath;

    public XPathListener(XPathSupport support, String expr) throws IllegalArgumentException, SAXPathException {
        this(support, expr, null, null);
    }

    public XPathListener(XPathSupport support, String expr, Map nss) throws IllegalArgumentException, SAXPathException {
        this(support, expr, nss, null);
    }

    public XPathListener(XPathSupport support, String expr, PacketListener match) throws IllegalArgumentException, SAXPathException {
        this(XPathListener.createXPath(support, expr), match);
    }

    public XPathListener(XPathSupport support, String expr, Map nss, PacketListener match) throws IllegalArgumentException, SAXPathException {
        this(XPathListener.createXPath(support, expr), match);
        this.setupNamespaces(nss);
    }

    public XPathListener(XPath path) throws IllegalArgumentException {
        this(path, null);
    }

    public XPathListener(XPath path, PacketListener match) throws IllegalArgumentException {
        this.setXPath(path);
        this.setMatchedListener(match);
    }

    public XPath getXPath() {
        return this._XPath;
    }

    private void setXPath(XPath path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("XPath object cannot be null");
        }
        this._XPath = path;
    }

    public PacketListener getMatchedListener() {
        return this._Match;
    }

    private void setMatchedListener(PacketListener match) {
        this._Match = match;
    }

    public void setupNamespaces(Set nss) throws RuntimeException {
        Utilities.setupNamespaces(this.getXPath(), nss);
    }

    public void setupNamespaces(Map nss) throws RuntimeException {
        Utilities.setupNamespaces(this.getXPath(), nss);
    }

    public void packetMatched(PacketEvent evt) {
        PacketListener l = this.getMatchedListener();
        if (l != null) {
            l.packetTransferred(evt);
        }
    }

    public void packetTransferred(PacketEvent evt) {
        StreamContext ctx = evt.getContext();
        StreamDataFactory sdf = ctx.getDataFactory();
        StreamElement base = sdf.createElementNode(sdf.createNSI("stream", ctx.getNamespaceURI("")));
        Packet target = evt.getData();
        StreamElement parent = target.getParent();
        target.setParent(null);
        base.add(target);
        try {
            if (this.getXPath().selectSingleNode((Object)base) != null) {
                base.remove(target);
                target.setParent(parent);
                this.packetMatched(evt);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        target.setParent(parent);
    }

    private static final XPath createXPath(XPathSupport support, String expr) throws IllegalArgumentException, SAXPathException {
        if (support == null) {
            throw new IllegalArgumentException("XPathSupport cannot be null");
        }
        if (!Utilities.isValidString(expr)) {
            throw new IllegalArgumentException("XPath expression cannot be null or \"\"");
        }
        if (!expr.startsWith("./")) {
            expr = (expr.startsWith("/") ? "." : "./") + expr;
        }
        return support.createXPath(expr);
    }
}

