/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.util.Utilities;

public class PacketWatcher {
    private Packet _Lost;
    private Packet _Found;

    public PacketWatcher(Packet template) throws IllegalArgumentException {
        this.setTemplatePacket(template);
        this.setFoundPacket(null);
    }

    public Packet getTemplatePacket() {
        return this._Lost;
    }

    protected void setTemplatePacket(Packet template) throws IllegalArgumentException {
        if (template == null) {
            throw new IllegalArgumentException("Packet cannot be null");
        }
        this._Lost = template;
    }

    public Packet getFoundPacket() {
        return this._Found;
    }

    protected void setFoundPacket(Packet found) {
        this._Found = found;
    }

    public Packet watch(Stream s) throws IllegalArgumentException, StreamException {
        return this.watch(s, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet watch(Stream s, long timeout) throws IllegalArgumentException, StreamException {
        if (s == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        PacketWatcher packetWatcher = this;
        synchronized (packetWatcher) {
            Watcher l = new Watcher();
            try {
                boolean elapsed;
                boolean found;
                s.addPacketListener(PacketEvent.RECEIVED, l);
                long start = System.currentTimeMillis();
                do {
                    long end;
                    try {
                        this.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    elapsed = timeout >= 0L ? (end = System.currentTimeMillis()) - start >= timeout : false;
                    s.process();
                    boolean bl = found = this.getFoundPacket() != null;
                } while (s.getCurrentStatus().isOpened() && !found && !elapsed);
            }
            finally {
                s.removePacketListener(PacketEvent.RECEIVED, l);
            }
        }
        return this.getFoundPacket();
    }

    public Packet sendAndWatch(Stream s) throws IllegalArgumentException, StreamException {
        return this.sendAndWatch(s, s, -1L);
    }

    public Packet sendAndWatch(PacketRouter r, PacketDispatcher d) throws IllegalArgumentException, StreamException {
        return this.sendAndWatch(r, d, -1L);
    }

    public Packet sendAndWatch(Stream s, long timeout) throws IllegalArgumentException, StreamException {
        return this.sendAndWatch(s, s, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet sendAndWatch(PacketRouter r, PacketDispatcher d, long timeout) throws IllegalArgumentException, StreamException {
        if (r == null) {
            throw new IllegalArgumentException("PacketRouter cannot be null");
        }
        if (d == null) {
            throw new IllegalArgumentException("PacketDispatcher cannot be null");
        }
        PacketWatcher packetWatcher = this;
        synchronized (packetWatcher) {
            Watcher l = new Watcher();
            try {
                boolean elapsed;
                boolean found;
                d.addPacketListener(PacketEvent.RECEIVED, l);
                r.send(this.getTemplatePacket());
                long start = System.currentTimeMillis();
                do {
                    long end;
                    try {
                        this.wait(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    elapsed = timeout >= 0L ? (end = System.currentTimeMillis()) - start >= timeout : false;
                    r.process();
                    boolean bl = found = this.getFoundPacket() != null;
                } while (r.getCurrentStatus().isOpened() && !found && !elapsed);
            }
            finally {
                d.removePacketListener(PacketEvent.RECEIVED, l);
            }
        }
        return this.getFoundPacket();
    }

    public static Packet watch(Stream s, Packet p) throws IllegalArgumentException, StreamException {
        return PacketWatcher.watch(s, p, -1L);
    }

    public static Packet watch(Stream s, Packet p, long timeout) throws IllegalArgumentException, StreamException {
        PacketWatcher w = new PacketWatcher(p);
        return w.watch(s, timeout);
    }

    public static Packet sendAndWatch(Stream s, Packet p) throws IllegalArgumentException, StreamException {
        return PacketWatcher.sendAndWatch(s, s, p, -1L);
    }

    public static Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p) throws IllegalArgumentException, StreamException {
        return PacketWatcher.sendAndWatch(r, d, p, -1L);
    }

    public static Packet sendAndWatch(Stream s, Packet p, long timeout) throws IllegalArgumentException, StreamException {
        return PacketWatcher.sendAndWatch(s, s, p, timeout);
    }

    public static Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, long timeout) throws IllegalArgumentException, StreamException {
        PacketWatcher w = new PacketWatcher(p);
        return w.sendAndWatch(r, d, timeout);
    }

    protected class Watcher
    implements PacketListener {
        protected Watcher() {
        }

        public void packetTransferred(PacketEvent evt) {
            Packet data = evt.getData();
            Packet template = PacketWatcher.this.getTemplatePacket();
            NSI name1 = template.getNSI();
            NSI name2 = data.getNSI();
            String id1 = template.getID();
            String id2 = data.getID();
            if (NSI.NS_LOOSE_COMPARATOR.compare(name1, name2) == 0 && Utilities.equateStrings(id1, id2)) {
                PacketWatcher.this.setFoundPacket(data);
            }
        }
    }
}

