/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import org.apache.log4j.Logger;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.MonitorEvent;
import org.jabberstudio.jso.event.MonitorListener;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketMonitorEvent;
import org.jabberstudio.jso.util.Monitor;
import org.jabberstudio.jso.util.Utilities;

public class PacketMonitor
extends Monitor {
    protected Monitor.MonitorTask createMonitorTask(Packet p, MonitorListener l) throws IllegalArgumentException, IllegalStateException {
        if (p == null) {
            throw new IllegalArgumentException("Expected Packet cannot be null");
        }
        PacketRouter router = this.getRouter();
        PacketDispatcher dispatch = this.getDispatcher();
        if (router == null) {
            throw new IllegalStateException("PacketRouter is not valid");
        }
        if (dispatch == null) {
            throw new IllegalStateException("PacketDispatcher is not valid");
        }
        return new Matcher(p, l);
    }

    public static final Packet sendAndWatch(Stream s, Packet p) throws IllegalArgumentException, StreamException {
        return PacketMonitor.sendAndWatch(s, p, -1L, 10L);
    }

    public static final Packet sendAndWatch(Stream s, Packet p, long t) throws IllegalArgumentException, StreamException {
        return PacketMonitor.sendAndWatch(s, p, t, 10L);
    }

    public static final Packet sendAndWatch(Stream s, Packet p, long t, long i) throws IllegalArgumentException, StreamException {
        if (s == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        return PacketMonitor.sendAndWatch(s, s, p, t, i);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p) throws IllegalArgumentException, StreamException {
        return PacketMonitor.sendAndWatch(r, d, p, -1L, 10L);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, long t) throws IllegalArgumentException, StreamException {
        return PacketMonitor.sendAndWatch(r, d, p, t, 10L);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, long t, long i) throws IllegalArgumentException, StreamException {
        if (r == null) {
            throw new IllegalArgumentException("PacketRouter cannot be null");
        }
        if (d == null) {
            throw new IllegalArgumentException("PacketDispatcher cannot be null");
        }
        PacketMonitor mon = new PacketMonitor();
        mon.setRouter(r);
        mon.setDispatcher(d);
        mon.setTimeout(t);
        mon.setProcessInterval(i);
        return mon.sendAndWatch(p);
    }

    private class Matcher
    extends Monitor.MonitorTask {
        private Packet _Expect;

        public Matcher(Packet expect, MonitorListener l) {
            super(l);
            Logger log = PacketMonitor.this.obtainLogger();
            this._Expect = expect;
            if (log.isDebugEnabled()) {
                log.debug((Object)("packet matcher against " + expect));
            }
        }

        public final Packet getExpected() {
            return this._Expect;
        }

        protected boolean matched(Packet actual) {
            Logger log = PacketMonitor.this.obtainLogger();
            Packet expected = this.getExpected();
            boolean check = true;
            NSI name1 = expected.getNSI();
            NSI name2 = actual.getNSI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("validating NSI (expected=" + name1 + ";actual=" + name2 + ")"));
            }
            check = NSI.NS_LOOSE_COMPARATOR.compare(name1, name2) == 0;
            String id1 = expected.getID();
            if (check && Utilities.isValidString(id1)) {
                String id2 = actual.getID();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("validating ID (expected=" + id1 + ";actual=" + id2 + ")"));
                }
                check = Utilities.equateStrings(id1, id2);
            }
            return check;
        }

        protected void fireMonitorFound(Packet actual) {
            PacketMonitorEvent evt = PacketMonitorEvent.createFoundEvent(PacketMonitor.this, this.getExpected(), actual);
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorFound(evt);
            }
        }

        protected void fireMonitorTimeout() {
            PacketMonitorEvent evt = PacketMonitorEvent.createTimeoutEvent(PacketMonitor.this, this.getExpected());
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorTimeout(evt);
            }
        }

        protected void fireMonitorFailed(StreamException cause) {
            MonitorEvent evt = PacketMonitorEvent.createFailedEvent(PacketMonitor.this, this.getExpected(), cause);
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorFailed(evt);
            }
        }
    }
}

