/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.MonitorEvent;
import org.jabberstudio.jso.event.MonitorListener;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;

public abstract class Monitor {
    public static final int DEFAULT_TIMEOUT = -1;
    public static final int DEFAULT_PROC_INTERVAL = 10;
    private PacketRouter _Router;
    private PacketDispatcher _Dispatch;
    private Timer _Timer;
    private boolean _ProcRouter = true;
    private long _Timeout = -1L;
    private long _ProcInt = 10L;
    private boolean _Running;
    private static Timer _DefaultTimer;

    protected final Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }

    protected static final synchronized Timer getDefaultTimer() {
        if (_DefaultTimer == null) {
            _DefaultTimer = new Timer(true);
        }
        return _DefaultTimer;
    }

    public final synchronized PacketRouter getRouter() {
        return this._Router;
    }

    public final synchronized void setRouter(PacketRouter r) {
        this._Router = r;
    }

    public final synchronized PacketDispatcher getDispatcher() {
        return this._Dispatch;
    }

    public final synchronized void setDispatcher(PacketDispatcher d) {
        this._Dispatch = d;
    }

    public final synchronized Timer getTimer() {
        return this._Timer;
    }

    public final synchronized void setTimer(Timer t) {
        this._Timer = t;
    }

    public final synchronized long getTimeout() {
        return this._Timeout;
    }

    public final synchronized void setTimeout(long t) {
        this._Timeout = t < -1L ? -1L : t;
    }

    public final synchronized boolean isProcessRouter() {
        return this._ProcRouter;
    }

    public final synchronized void setProcessRouter(boolean proc) {
        this._ProcRouter = proc;
    }

    public final synchronized long getProcessInterval() {
        return this._ProcInt;
    }

    public final synchronized void setProcessInterval(long i) {
        this._ProcInt = i < 1L ? 10L : i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet p, MonitorListener l) throws IllegalArgumentException, IllegalStateException {
        Timer timer;
        long interval;
        MonitorTask match;
        if (l == null) {
            throw new IllegalArgumentException("MonitorListener cannot be null");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            match = this.createMonitorTask(p, l);
            interval = this.getProcessInterval();
            timer = this.getTimer();
            if (timer == null) {
                timer = Monitor.getDefaultTimer();
            }
        }
        timer.schedule((TimerTask)match, 0L, interval);
        match.send(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet sendAndWatch(Packet p) throws IllegalArgumentException, IllegalStateException, StreamException {
        MonitorTask match;
        Monitor monitor = this;
        synchronized (monitor) {
            match = this.createMonitorTask(p, null);
        }
        match.send(p);
        return this.watch(match);
    }

    protected abstract MonitorTask createMonitorTask(Packet var1, MonitorListener var2) throws IllegalStateException;

    protected final synchronized Packet watch(MonitorTask task) throws StreamException {
        while (task.isRunning()) {
            task.run();
            try {
                Thread.sleep(this.getProcessInterval());
            }
            catch (InterruptedException ie) {
                this.obtainLogger().error((Object)"sleep thread interrupted", (Throwable)ie);
            }
        }
        MonitorEvent evt = task.getEvent();
        if (evt.getReason() == MonitorEvent.FAILED) {
            throw evt.getCause();
        }
        return evt.getActualPacket();
    }

    protected abstract class MonitorTask
    extends TimerTask
    implements PacketListener {
        private boolean _Proccing;
        private PacketRouter _Router;
        private PacketDispatcher _Dispatch;
        private long _Start;
        private long _Timeout;
        private boolean _Running;
        private MonitorEvent _Event;
        private MonitorListener _Listener;

        public MonitorTask(MonitorListener l) {
            this._Proccing = Monitor.this.isProcessRouter();
            this._Router = Monitor.this.getRouter();
            this._Dispatch = Monitor.this.getDispatcher();
            this._Timeout = Monitor.this.getTimeout();
            this.getDispatcher().addPacketListener(PacketEvent.RECEIVED, this);
            this._Listener = l;
            this._Start = System.currentTimeMillis();
            this._Running = true;
        }

        public final boolean isProcessRouter() {
            return this._Proccing;
        }

        public final PacketRouter getRouter() {
            return this._Router;
        }

        public final PacketDispatcher getDispatcher() {
            return this._Dispatch;
        }

        public final long getStartingTime() {
            return this._Start;
        }

        public final long getTimeout() {
            return this._Timeout;
        }

        public final MonitorEvent getEvent() {
            return this._Event;
        }

        public final MonitorListener getListener() {
            return this._Listener;
        }

        public final boolean isRunning() {
            return this._Running;
        }

        protected final synchronized void stop(MonitorEvent evt) throws IllegalArgumentException {
            if (evt == null) {
                throw new IllegalArgumentException("MonitorEvent cannot be null");
            }
            this._Running = false;
            this._Event = evt;
            this.cancel();
            this.getDispatcher().removePacketListener(PacketEvent.RECEIVED, this);
        }

        protected void send(Packet p) {
            try {
                this.getRouter().send(p);
            }
            catch (StreamException se) {
                try {
                    Monitor.this.obtainLogger().error((Object)"could not send monitor packet", (Throwable)se);
                    this.fireMonitorFailed(se);
                }
                catch (Throwable t) {
                    Monitor.this.obtainLogger().warn((Object)"error when firing monitor failed event", t);
                }
            }
        }

        public void packetTransferred(PacketEvent evt) {
            Logger log = Monitor.this.obtainLogger();
            Packet input = evt.getData();
            if (log.isDebugEnabled()) {
                log.debug((Object)("attempting to match packet " + evt.getData()));
            }
            if (this.matched(input)) {
                try {
                    log.info((Object)"expected packet found");
                    this.fireMonitorFound(input);
                }
                catch (Throwable t) {
                    Monitor.this.obtainLogger().warn((Object)"error when firing monitor found event", t);
                }
            }
        }

        public void run() {
            Logger log = Monitor.this.obtainLogger();
            PacketRouter router = this.getRouter();
            long start = this.getStartingTime();
            long timeout = this.getTimeout();
            boolean valid = true;
            try {
                if (!router.getInboundContext().getCurrentStatus().isConnected()) {
                    try {
                        this.fireMonitorFailed(new StreamException(router.getDataFactory().createStreamError("remote-connection-failed")));
                    }
                    catch (Throwable t) {
                        log.warn((Object)"error when firing monitor failed event", t);
                    }
                }
                if (this.isProcessRouter()) {
                    router.process();
                }
                if (this.isRunning() && timeout > -1L && System.currentTimeMillis() - start > timeout) {
                    if (this.isProcessRouter()) {
                        router.process();
                    }
                    boolean bl = valid = !this.isRunning();
                }
                if (!valid) {
                    try {
                        log.info((Object)"monitor timed out");
                        this.fireMonitorTimeout();
                    }
                    catch (Throwable t) {
                        log.warn((Object)"error when firing monitor timeout event", t);
                    }
                }
            }
            catch (StreamException se) {
                try {
                    log.error((Object)"monitor failed to process router");
                    this.fireMonitorFailed(se);
                }
                catch (Throwable t) {
                    log.warn((Object)"error when firing monitor failed event", t);
                }
            }
        }

        protected abstract boolean matched(Packet var1);

        protected abstract void fireMonitorFound(Packet var1);

        protected abstract void fireMonitorTimeout();

        protected abstract void fireMonitorFailed(StreamException var1);
    }
}

