/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.tls;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.io.src.SocketStreamSource;
import org.jabberstudio.jso.tls.StartTLSPacket;

public class StartTLSSocketStreamSource
extends SocketStreamSource {
    private Stream _Conn;
    private SSLContext _Ctx;
    private boolean _Secured;

    public StartTLSSocketStreamSource(String host, int port) throws IllegalArgumentException, NoSuchAlgorithmException, UnknownHostException, IOException {
        this(new Socket(host, port), SSLContext.getInstance("TLS"));
    }

    public StartTLSSocketStreamSource(String host, int port, SSLContext ctx) throws IllegalArgumentException, UnknownHostException, IOException {
        this(new Socket(host, port), ctx);
    }

    public StartTLSSocketStreamSource(Socket plain) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(plain, SSLContext.getInstance("TLS"));
    }

    public StartTLSSocketStreamSource(Socket plain, SSLContext ctx) throws IllegalArgumentException {
        super(plain);
        if (ctx == null) {
            throw new IllegalArgumentException("SSLContext cannot be null");
        }
        this._Ctx = ctx;
    }

    public boolean isSecured() {
        return this._Secured;
    }

    private void setSecured(boolean secured) {
        this._Secured = secured;
    }

    public SSLContext getTLSContext() {
        return this._Ctx;
    }

    protected Stream getStream() {
        return this._Conn;
    }

    public void connect(Stream s) throws IOException, Exception {
        super.connect(s);
        this._Conn = s;
    }

    public void disconnect(Stream s) throws IOException, Exception {
        this._Conn = null;
        super.disconnect(s);
    }

    public synchronized void negotiateClientTLS() throws IOException {
        SSLContext ctx = this.getTLSContext();
        Socket plain = this.getSocket();
        String host = plain.getInetAddress().getHostName();
        int port = plain.getPort();
        this.getInputQueue().stopAndWait(false);
        SSLSocket secure = (SSLSocket)ctx.getSocketFactory().createSocket(plain, host, port, true);
        this.configureSocket(secure, null);
        this.setSocket(secure);
        this.setInput(secure.getInputStream());
        this.setOutput(secure.getOutputStream());
        secure.startHandshake();
        this.setSecured(true);
        this.getInputQueue().start();
    }

    public synchronized void negotiateServerTLS() throws StreamException, IOException {
        Stream conn = this.getStream();
        SSLContext ctx = this.getTLSContext();
        Socket plain = this.getSocket();
        String host = plain.getLocalAddress().getHostName();
        int port = plain.getLocalPort();
        this.getInputQueue().stopAndWait(false);
        StartTLSPacket proceed = (StartTLSPacket)conn.getDataFactory().createPacketNode(StartTLSPacket.NAME_PROCEED);
        conn.send(proceed);
        SSLSocket secure = (SSLSocket)ctx.getSocketFactory().createSocket(plain, host, port, true);
        secure.setUseClientMode(false);
        secure.setNeedClientAuth(true);
        this.configureSocket(secure, null);
        this.setSocket(secure);
        this.setInput(secure.getInputStream());
        this.setOutput(secure.getOutputStream());
        this.setSecured(true);
        this.getInputQueue().start();
    }
}

