/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.util.StreamSourceProxy;
import org.jabberstudio.jso.util.Utilities;

public class SASLStreamSource
extends StreamSourceProxy {
    private SASLMechanism _Mech;
    private boolean _Secured;
    private int _MaxRcvd;
    private int _MaxSend;
    private ByteBuffer _Buffer;

    public SASLStreamSource(StreamSource base) throws IllegalArgumentException {
        super(base);
    }

    public SASLMechanism getMechanism() {
        return this._Mech;
    }

    public synchronized void setMechanism(SASLMechanism mech) {
        this._Mech = mech;
        if (this._Mech != null) {
            String qop = (String)this._Mech.getProperties().get("javax.security.sasl.qop");
            boolean bl = this._Secured = Utilities.equateStrings(qop, "auth-int") || Utilities.equateStrings(qop, "auth-conf");
            if (this._Secured) {
                try {
                    this._MaxRcvd = Integer.parseInt((String)this._Mech.getProperties().get("javax.security.sasl.maxbuffer"));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                try {
                    this._MaxSend = this._MaxRcvd / 2;
                }
                catch (NumberFormatException nfe) {
                    this._MaxSend = this._MaxRcvd / 2;
                }
            }
        } else {
            this._Secured = false;
            this._MaxRcvd = 0;
            this._MaxSend = 0;
        }
    }

    public boolean isSecured() {
        return this._Secured;
    }

    private int getMaxReceive() {
        return this._MaxRcvd;
    }

    private int getMaxSend() {
        return this._MaxSend;
    }

    private ByteBuffer getBuffer() {
        return this._Buffer;
    }

    private void setBuffer(ByteBuffer buffer) {
        this._Buffer = buffer;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        int amt = length;
        amt = this.isSecured() ? this.readBuffer(buffer, offset, length) : super.read(buffer, offset, length);
        return amt;
    }

    public synchronized int write(byte[] buffer, int offset, int length) throws IOException {
        int amt = length;
        amt = this.isSecured() ? this.writeBuffer(buffer, offset, length) : super.write(buffer, offset, length);
        return amt;
    }

    private final int readBuffer(byte[] data, int offset, int length) throws IOException {
        SASLMechanism mech = this.getMechanism();
        ByteBuffer buffer = this.getBuffer();
        int amt = 0;
        if (buffer == null || !buffer.hasRemaining()) {
            byte[] header = new byte[4];
            super.read(header, 0, header.length);
            int size = header[0] << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
            byte[] input = new byte[size];
            amt = super.read(input, 0, input.length);
            input = mech.unwrap(input);
            buffer = ByteBuffer.allocate(input.length);
            this.setBuffer(buffer);
        }
        amt = buffer.remaining() < length ? buffer.remaining() : length;
        buffer.get(data, offset, amt);
        return amt;
    }

    private final int writeBuffer(byte[] data, int offset, int length) throws IOException {
        SASLMechanism mech = this.getMechanism();
        int amt = 0;
        int max = this.getMaxSend();
        for (int size = length; size > 0; size -= max) {
            byte[] body = new byte[size > max ? max : size];
            System.arraycopy(data, offset + amt, body, 0, body.length);
            amt += body.length;
            body = mech.wrap(body);
            byte[] output = new byte[body.length + 4];
            output[0] = (byte)(body.length >>> 24);
            output[1] = (byte)(body.length >>> 16);
            output[2] = (byte)(body.length >>> 8);
            output[3] = (byte)body.length;
            System.arraycopy(body, 0, output, 4, body.length);
            super.write(output, 0, output.length);
        }
        return amt;
    }
}

