/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl;

import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.sasl.SASLMechanismManager;
import org.jabberstudio.jso.util.Utilities;

public class SASLServerInfo {
    private String _Mech;
    private String _Service;
    private Map _Props;
    private CallbackHandler _CBH;
    private StreamDataFactory _SDF;

    public SASLServerInfo() {
        this(null);
    }

    public SASLServerInfo(Stream conn) {
        StreamDataFactory sdf = null;
        JID host = null;
        if (conn != null) {
            sdf = conn.getDataFactory();
            host = conn.getOutboundContext().getFrom();
        }
        this._Mech = "";
        this._Props = new TreeMap();
        this.setDataFactory(sdf);
        this.setServer(host != null ? host.getDomain() : "");
    }

    public String getMechanismName() {
        return this._Mech;
    }

    public void setMechanismName(String mech) {
        this._Mech = mech != null ? mech : "";
    }

    public String getServer() {
        return this._Service;
    }

    public void setServer(String srv) {
        this._Service = srv != null ? srv : "";
    }

    public Map getProperties() {
        return this._Props;
    }

    public void setProperties(Map props) {
        this._Props.clear();
        this._Props.putAll(SASLMechanismManager.DEFAULT_PROPERTIES);
        if (props != null) {
            this._Props.putAll(props);
        }
    }

    public CallbackHandler getCallbackHandler() {
        return this._CBH;
    }

    public void setCallbackHandler(CallbackHandler cbh) {
        this._CBH = cbh;
    }

    public StreamDataFactory getDataFactory() {
        if (this._SDF == null) {
            this._SDF = JSOImplementation.getInstance().getDataFactory();
        }
        return this._SDF;
    }

    public void setDataFactory(StreamDataFactory sdf) {
        this._SDF = sdf;
    }

    public boolean isValid() {
        return Utilities.isValidString(this.getMechanismName()) && Utilities.isValidString(this.getServer());
    }
}

