/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.sasl.SASLMechanismManager;
import org.jabberstudio.jso.util.Utilities;

public class SASLClientInfo {
    private List _Mechs;
    private String _Service;
    private JID _Authzid;
    private Map _Props;
    private CallbackHandler _CBH;
    private StreamDataFactory _SDF;

    public SASLClientInfo() {
        this(null);
    }

    public SASLClientInfo(Stream conn) {
        StreamDataFactory sdf = null;
        JID host = null;
        if (conn != null) {
            sdf = conn.getDataFactory();
            host = conn.getOutboundContext().getTo();
        }
        this._Mechs = new ArrayList();
        this._Props = new TreeMap();
        this.setDataFactory(sdf);
        this.setServer(host != null ? host.getDomain() : "");
    }

    public List getMechanismNames() {
        return this._Mechs;
    }

    public void setMechanismNames(List mechs) {
        this._Mechs.clear();
        if (mechs != null) {
            this._Mechs.addAll(mechs);
        }
    }

    public JID getAuthorizationID() {
        return this._Authzid;
    }

    public void setAuthorizationID(JID authzid) {
        this._Authzid = authzid;
    }

    public String getServer() {
        return this._Service;
    }

    public void setServer(String srv) {
        this._Service = srv != null ? srv : "";
    }

    public Map getProperties() {
        return this._Props;
    }

    public void setProperties(Map props) {
        this._Props.clear();
        this._Props.putAll(SASLMechanismManager.DEFAULT_PROPERTIES);
        if (props != null) {
            this._Props.putAll(props);
        }
    }

    public CallbackHandler getCallbackHandler() {
        return this._CBH;
    }

    public void setCallbackHandler(CallbackHandler cbh) {
        this._CBH = cbh;
    }

    public StreamDataFactory getDataFactory() {
        if (this._SDF == null) {
            this._SDF = JSOImplementation.getInstance().getDataFactory();
        }
        return this._SDF;
    }

    public void setDataFactory(StreamDataFactory sdf) {
        this._SDF = sdf;
    }

    public boolean isValid() {
        return !this.getMechanismNames().isEmpty() && Utilities.isValidString(this.getServer());
    }
}

