/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.jabberstudio.jso.io.src.ChannelStreamSource;

public class SelectableChannelStreamSource
extends ChannelStreamSource {
    public SelectableChannelStreamSource(ByteChannel sc) throws IllegalArgumentException {
        super(sc);
    }

    public int write(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        ByteChannel channel = this.getChannel();
        boolean amt = false;
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (offset < 0 || buffer.length < offset + length) {
            throw new IllegalArgumentException("offset not in valid range");
        }
        if (length < 0 || length > buffer.length - offset) {
            throw new IllegalArgumentException("length not in valid range");
        }
        ByteBuffer out = ByteBuffer.wrap(buffer, offset, length);
        return channel.write(out);
    }
}

