/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.InputStreamQueue;

public class IOStreamSource
implements StreamSource {
    private InputStreamQueue _Input;
    private OutputStream _Output;

    protected IOStreamSource() {
    }

    public IOStreamSource(InputStream in, OutputStream out) throws IOException, IllegalArgumentException {
        this.setInput(in);
        this.setOutput(out);
    }

    public void connect(Stream s) throws IOException, Exception {
        this._Input.start();
    }

    public void disconnect(Stream s) throws IOException, Exception {
        this._Input.stop();
        this._Output.close();
    }

    public String getHostname() {
        return "localhost";
    }

    protected InputStreamQueue getInputQueue() {
        return this._Input;
    }

    protected void setInput(InputStream in) throws IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this._Input = new InputStreamQueue("jso-ioss:" + this.getHostname(), in, 8191);
    }

    protected void setOutput(OutputStream out) throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        this._Output = out;
    }

    public boolean ready() throws IOException {
        return this._Input.isValid();
    }

    public int read(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        return this._Input.read(buffer, offset, length);
    }

    public int write(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        this._Output.write(buffer, offset, length);
        this._Output.flush();
        return length;
    }
}

