/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.format;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.util.Utilities;

public class LocaleFormat
extends Format {
    public static final Field LANGUAGE_FIELD = new Field("language");
    public static final Field COUNTRY_FIELD = new Field("country");
    private static final Pattern RE_XMLLANG = Pattern.compile("(\\w{1,8})(-(\\w{1,8}))?");
    private static final LocaleFormat _Instance = new LocaleFormat();

    private LocaleFormat() {
    }

    public String format(Locale l) throws IllegalArgumentException {
        return this.format((Object)l);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) throws IllegalArgumentException {
        AttributedCharacterIterator itr = this.formatToCharacterIterator(obj, toAppendTo);
        if (pos != null) {
            if (pos.getFieldAttribute() == LANGUAGE_FIELD) {
                pos.setBeginIndex(itr.getRunStart(LANGUAGE_FIELD));
                pos.setEndIndex(itr.getRunLimit(LANGUAGE_FIELD));
            }
            itr.setIndex(itr.getRunStart(LANGUAGE_FIELD));
            if (pos.getFieldAttribute() == COUNTRY_FIELD) {
                pos.setBeginIndex(itr.getRunStart(COUNTRY_FIELD));
                pos.setEndIndex(itr.getRunLimit(COUNTRY_FIELD));
            }
            itr.setIndex(itr.getRunStart(COUNTRY_FIELD));
        }
        return toAppendTo;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object obj) throws IllegalArgumentException {
        return this.formatToCharacterIterator(obj, new StringBuffer());
    }

    private AttributedCharacterIterator formatToCharacterIterator(Object obj, StringBuffer toAppendTo) throws IllegalArgumentException {
        StringBuffer buffer = new StringBuffer();
        int start = toAppendTo.length();
        int[] begin = new int[2];
        int[] end = new int[2];
        if (obj == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (!(obj instanceof Locale)) {
            throw new IllegalArgumentException("object must be an instance of Locale");
        }
        Locale l = (Locale)obj;
        HashMap<Field, String> attrMap = new HashMap<Field, String>();
        String lang = l.getLanguage();
        String cn = l.getCountry();
        begin[0] = start + buffer.length();
        buffer.append(lang);
        end[0] = start + buffer.length();
        attrMap.put(LANGUAGE_FIELD, lang);
        if (Utilities.isValidString(cn)) {
            begin[1] = start + buffer.length();
            buffer.append('-').append(cn);
            end[1] = start + buffer.length();
            attrMap.put(COUNTRY_FIELD, cn);
        }
        int finish = start + buffer.length();
        toAppendTo.append(buffer);
        AttributedString attrStr = new AttributedString(buffer.toString(), attrMap);
        if (Utilities.isValidString(lang)) {
            attrStr.addAttribute(LANGUAGE_FIELD, lang, begin[0], end[0]);
        }
        if (Utilities.isValidString(cn)) {
            attrStr.addAttribute(COUNTRY_FIELD, cn, begin[1], end[1]);
        }
        return attrStr.getIterator();
    }

    public Locale parse(String source) throws ParseException {
        return (Locale)this.parseObject(source);
    }

    public Object parseObject(String source, ParsePosition pos) throws NullPointerException {
        Locale lang = null;
        if (source == null) {
            source = "";
        }
        try {
            Matcher match = RE_XMLLANG.matcher(source.substring(pos.getIndex()));
            if (match.find() && match.start() == 0) {
                String pri = match.group(1);
                String sec = match.group(3);
                lang = Utilities.isValidString(sec) ? new Locale(pri, sec) : new Locale(pri);
                pos.setIndex(match.end() + pos.getIndex());
            } else {
                pos.setErrorIndex(pos.getIndex());
            }
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            pos.setErrorIndex(pos.getIndex());
        }
        return lang;
    }

    public static LocaleFormat getInstance() {
        return _Instance;
    }

    private static class Field
    extends Format.Field {
        public Field(String name) {
            super(name);
        }
    }
}

