/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso;

import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElementRegistry;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.StreamFeaturesDispatcher;
import org.jabberstudio.jso.event.StreamStatusDispatcher;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.Enumerator;

public interface Stream
extends StreamElementRegistry,
StreamStatusDispatcher,
StreamFeaturesDispatcher,
PacketDispatcher,
PacketRouter {
    public static final Status DISCONNECTED = new Status("disconnected", false, false);
    public static final Status CONNECTED = new Status("connected", true, false);
    public static final Status OPENED = new Status("opened", true, true);
    public static final Status CLOSED = new Status("closed", true, false);

    public Status getCurrentStatus();

    public String getDefaultNamespace();

    public JSOImplementation getJSO();

    public StreamDataFactory getDataFactory();

    public StreamContext getInboundContext();

    public Status getInboundStatus();

    public StreamContext getOutboundContext();

    public Status getOutboundStatus();

    public void connect(StreamSource var1) throws IllegalArgumentException, StreamException;

    public void disconnect() throws StreamException;

    public void open() throws StreamException;

    public void open(long var1) throws StreamException;

    public void drop() throws StreamException;

    public void close() throws StreamException;

    public void close(long var1) throws StreamException;

    public void close(StreamException var1) throws StreamException;

    public void close(StreamException var1, long var2) throws StreamException;

    public void send(Packet var1) throws StreamException;

    public void process() throws StreamException;

    public void openOutbound() throws StreamException;

    public void openInbound(long var1) throws StreamException;

    public static final class Status
    extends Enumerator {
        private boolean _Connected;
        private boolean _Opened;

        private Status(String name, boolean conn, boolean opn) {
            super(name);
            this._Connected = conn;
            this._Opened = opn;
        }

        public boolean isDisconnected() {
            return !this.isConnected();
        }

        public boolean isConnected() {
            return this._Connected;
        }

        public boolean isOpened() {
            return this._Opened;
        }

        public static Status getAggregateStatus(Status in, Status out) throws IllegalArgumentException {
            if (in == null) {
                throw new IllegalArgumentException("Inbound status cannot be null");
            }
            if (out == null) {
                throw new IllegalArgumentException("Outbound status cannot be null");
            }
            Status curr = in.isOpened() && out.isOpened() ? OPENED : (in.isConnected() && out.isConnected() ? CONNECTED : DISCONNECTED);
            return curr;
        }
    }
}

