/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.util.Utilities;

public final class JID
implements Comparable,
Serializable {
    public static final Comparator STRICT_COMPARATOR = new Comparator(){

        public int compare(Object obj1, Object obj2) throws NullPointerException, JIDFormatException {
            String test2;
            JID jid2;
            JID jid1;
            int code = 0;
            JID jID = obj1 != null ? (obj1 instanceof JID ? (JID)obj1 : JID.valueOf(obj1)) : (jid1 = null);
            JID jID2 = obj2 != null ? (obj2 instanceof JID ? (JID)obj2 : JID.valueOf(obj2)) : (jid2 = null);
            if (jid1 == null || jid2 == null) {
                throw new NullPointerException("comparison objects cannot be null");
            }
            String test1 = jid1.getDomain();
            code = test1.compareToIgnoreCase(test2 = jid2.getDomain());
            if (code == 0) {
                test1 = jid1.getNode();
                test2 = jid2.getNode();
                code = test1.compareToIgnoreCase(test2);
            }
            if (code == 0) {
                test1 = jid1.getResource();
                test2 = jid2.getResource();
                code = test1.compareTo(test2);
            }
            return code;
        }
    };
    public static final Comparator LOOSE_COMPARATOR = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            String test2;
            JID jid2;
            JID jid1;
            int code = 0;
            JID jID = obj1 != null ? (obj1 instanceof JID ? (JID)obj1 : JID.valueOf(obj1)) : (jid1 = null);
            JID jID2 = obj2 != null ? (obj2 instanceof JID ? (JID)obj2 : JID.valueOf(obj2)) : (jid2 = null);
            if (jid1 == null || jid2 == null) {
                throw new NullPointerException("comparison objects cannot be null");
            }
            String test1 = jid1.getDomain();
            code = test1.compareToIgnoreCase(test2 = jid2.getDomain());
            if (code == 0) {
                test1 = jid1.getNode();
                test2 = jid2.getNode();
                int n = code = Utilities.isValidString(test1) && Utilities.isValidString(test2) ? test1.compareToIgnoreCase(test2) : 0;
            }
            if (code == 0) {
                test1 = jid1.getResource();
                test2 = jid2.getResource();
                code = Utilities.isValidString(test1) && Utilities.isValidString(test2) ? test1.compareToIgnoreCase(test2) : 0;
            }
            return code;
        }
    };
    private static final int NODE_LENGTH = 1024;
    private static final int DOMAIN_LENGTH = 1024;
    private static final int RESOURCE_LENGTH = 1024;
    private static final String NODEPREP = "([\\p{L}\\p{N}\\p{P}\\p{S}&&[^\\u0022\\u0026\\u0027\\u002f\\u003a\\u003c\\u003e\\u0040]]{1,1024})";
    private static final String DOMAINPREP = "([\\p{L}\\p{N}\\p{Pd}\\.\\:&&[^\\u0022]]{1,1024})";
    private static final String RESOURCEPREP = "([\\u0020\\p{L}\\p{N}\\p{P}\\p{M}\\p{S}]{1,1024})";
    private static final Pattern RE_PATTERN = Pattern.compile("(([\\p{L}\\p{N}\\p{P}\\p{S}&&[^\\u0022\\u0026\\u0027\\u002f\\u003a\\u003c\\u003e\\u0040]]{1,1024})@)?([\\p{L}\\p{N}\\p{Pd}\\.\\:&&[^\\u0022]]{1,1024})(/([\\u0020\\p{L}\\p{N}\\p{P}\\p{M}\\p{S}]{1,1024}))?", 32);
    private static final Pattern RE_NODE = Pattern.compile("([\\p{L}\\p{N}\\p{P}\\p{S}&&[^\\u0022\\u0026\\u0027\\u002f\\u003a\\u003c\\u003e\\u0040]]{1,1024})");
    private static final Pattern RE_DOMAIN = Pattern.compile("([\\p{L}\\p{N}\\p{Pd}\\.\\:&&[^\\u0022]]{1,1024})");
    private static final Pattern RE_RESOURCE = Pattern.compile("([\\u0020\\p{L}\\p{N}\\p{P}\\p{M}\\p{S}]{1,1024})");
    private static final int POS_NODE = 2;
    private static final int POS_DOMAIN = 3;
    private static final int POS_RESOURCE = 5;
    private String _Node;
    private String _Domain;
    private String _Resource;
    private String _Spec;

    public JID(String node, String domain, String resource) throws IllegalArgumentException {
        this.setDomain(domain);
        this.setNode(node);
        this.setResource(resource);
    }

    public JID(String spec) throws JIDFormatException {
        Matcher match = RE_PATTERN.matcher(spec != null ? spec : "");
        if (!match.matches()) {
            throw new JIDFormatException("object does not represent a valid JID");
        }
        this.setDomain(match.group(3));
        this.setNode(match.group(2));
        this.setResource(match.group(5));
        this.setSpecification(spec);
    }

    public JID(Object spec) throws JIDFormatException {
        this(spec != null ? spec.toString() : "");
    }

    private final String getSpecification() {
        return this._Spec;
    }

    private final void setSpecification(String spec) {
        this._Spec = spec;
    }

    public final String getNode() {
        return this._Node;
    }

    public final boolean hasNode() {
        return Utilities.isValidString(this._Node);
    }

    private final void setNode(String node) throws JIDFormatException {
        if (!JID.isValidNode(node)) {
            throw new JIDFormatException("node is not valid");
        }
        this._Node = node != null ? node : "";
    }

    public static final boolean isValidNode(String node) {
        boolean valid = true;
        if (Utilities.isValidString(node)) {
            valid = node.length() <= 1024 && RE_NODE.matcher(node).matches();
        }
        return valid;
    }

    public final String getDomain() {
        return this._Domain;
    }

    private final void setDomain(String domain) throws JIDFormatException {
        if (!JID.isValidDomain(domain)) {
            throw new JIDFormatException("domain is not a valid FQDN or IP address");
        }
        this._Domain = domain;
    }

    public static final boolean isValidDomain(String domain) {
        boolean valid = false;
        if (Utilities.isValidString(domain)) {
            valid = domain.length() <= 1024 && RE_DOMAIN.matcher(domain).matches();
        }
        return valid;
    }

    public final String getResource() {
        return this._Resource;
    }

    public final boolean hasResource() {
        return Utilities.isValidString(this._Resource);
    }

    private final void setResource(String res) throws JIDFormatException {
        if (!JID.isValidResource(res)) {
            throw new JIDFormatException("resource is not valid");
        }
        this._Resource = res != null ? res : "";
    }

    public static final boolean isValidResource(String res) {
        boolean valid = true;
        if (Utilities.isValidString(res)) {
            valid = res.length() <= 1024 && RE_RESOURCE.matcher(res).matches();
        }
        return valid;
    }

    public final int hashCode() {
        int results = 23;
        results = 41 * results + this.getDomain().toLowerCase().hashCode();
        if (this.hasNode()) {
            results = 41 * results + this.getNode().toLowerCase().hashCode();
        }
        if (this.hasResource()) {
            results = 41 * results + this.getResource().hashCode();
        }
        return results;
    }

    public final boolean equals(Object cmp) {
        JID test = null;
        if (cmp instanceof JID) {
            test = (JID)cmp;
        } else if (JID.isValid(cmp)) {
            test = JID.valueOf(cmp);
        }
        return test != null ? this.equals(test) : false;
    }

    public final boolean equals(JID cmp) {
        boolean result;
        boolean bl = result = cmp != null;
        if (result) {
            result = this.getDomain().equalsIgnoreCase(cmp.getDomain());
            if (result) {
                result = this.getNode().equalsIgnoreCase(cmp.getNode());
            }
            if (result) {
                result = this.getResource().equals(cmp.getResource());
            }
        }
        return result;
    }

    public final int compareTo(Object cmp) {
        return STRICT_COMPARATOR.compare(this, cmp);
    }

    public final boolean match(Object cmp) {
        JID test = null;
        if (cmp instanceof JID) {
            test = (JID)cmp;
        } else {
            try {
                test = JID.valueOf(cmp.toString());
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.match(test);
    }

    public final boolean match(JID cmp) {
        boolean result;
        boolean bl = result = cmp != null;
        if (result) {
            result = this.getDomain().equalsIgnoreCase(cmp.getDomain());
        }
        if (result && Utilities.isValidString(this.getNode())) {
            result = this.getNode().equalsIgnoreCase(cmp.getNode());
        }
        if (result && Utilities.isValidString(this.getResource())) {
            result = this.getResource().equals(cmp.getResource());
        }
        return result;
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean normalize) {
        String spec = this.getSpecification();
        if (normalize || !Utilities.isValidString(spec)) {
            StringBuffer buffer = new StringBuffer();
            if (!this.getNode().equals("")) {
                buffer.append(normalize ? this.getNode().toLowerCase() : this.getNode()).append("@");
            }
            buffer.append(normalize ? this.getDomain().toLowerCase() : this.getDomain());
            if (!this.getResource().equals("")) {
                buffer.append("/").append(this.getResource());
            }
            spec = buffer.toString();
        }
        return spec;
    }

    public final JID toBareJID() {
        return new JID(this.getNode(), this.getDomain(), null);
    }

    public static final boolean isValid(Object spec) {
        Matcher match;
        boolean result = spec != null;
        Matcher matcher = match = result ? RE_PATTERN.matcher(spec.toString()) : null;
        if (match != null && match.matches()) {
            result = result && JID.isValidDomain(match.group(3));
            result = result && JID.isValidNode(match.group(2));
            result = result && JID.isValidResource(match.group(5));
        } else {
            result = false;
        }
        return result;
    }

    public static final JID valueOf(Object spec) throws JIDFormatException {
        return spec instanceof JID ? (JID)spec : new JID(spec != null ? spec.toString() : "");
    }
}

