/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.xpath;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.xpath.StreamNavigator;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jabberstudio.jso.xpath.EqualsJidFunction;
import org.jabberstudio.jso.xpath.EqualsLocaleFunction;
import org.jabberstudio.jso.xpath.ImplsClassFunction;
import org.jabberstudio.jso.xpath.IsClassFunction;
import org.jabberstudio.jso.xpath.IsJidFunction;
import org.jabberstudio.jso.xpath.JidDomainFunction;
import org.jabberstudio.jso.xpath.JidNodeFunction;
import org.jabberstudio.jso.xpath.JidResourceFunction;
import org.jabberstudio.jso.xpath.LocaleFunction;
import org.jabberstudio.jso.xpath.MatchJidFunction;
import org.jabberstudio.jso.xpath.MatchLocaleFunction;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleFunctionContext;

public class JSOXPath
extends BaseXPath {
    private static Map XPATH_FUNCTIONS;

    public JSOXPath(String xpath) throws JaxenException {
        this(xpath, new StreamNavigator());
    }

    public JSOXPath(String xpath, StreamNavigator nav) throws JaxenException {
        super(xpath, (Navigator)nav);
        SimpleFunctionContext fCtx = (SimpleFunctionContext)this.getFunctionContext();
        Iterator fItr = XPATH_FUNCTIONS.values().iterator();
        while (fItr.hasNext()) {
            ((AbstractFunction)fItr.next()).register(null, fCtx);
        }
        this.setFunctionContext(this.getFunctionContext());
        this.setVariableContext(this.getVariableContext());
    }

    public void setupNamespaces(StreamElement context) throws JaxenException {
        if (context != null) {
            StreamElement parent = context.getParent();
            if (parent != null) {
                this.setupNamespaces(parent);
            }
            Iterator nsItr = context.getDeclaredNamespaces().iterator();
            while (nsItr.hasNext()) {
                StreamNamespace nsObj = (StreamNamespace)nsItr.next();
                String nsURI = nsObj.getURI();
                String nsPrefix = nsObj.getPrefix();
                this.addNamespace(nsPrefix, nsURI);
            }
        }
    }

    static {
        TreeMap<String, AbstractFunction> funcs = new TreeMap<String, AbstractFunction>();
        AbstractFunction func = new IsJidFunction();
        funcs.put(func.getFunctionName(), func);
        func = new JidNodeFunction();
        funcs.put(func.getFunctionName(), func);
        func = new JidDomainFunction();
        funcs.put(func.getFunctionName(), func);
        func = new JidResourceFunction();
        funcs.put(func.getFunctionName(), func);
        func = new MatchJidFunction();
        funcs.put(func.getFunctionName(), func);
        func = new EqualsJidFunction();
        funcs.put(func.getFunctionName(), func);
        func = new IsClassFunction();
        funcs.put(func.getFunctionName(), func);
        func = new ImplsClassFunction();
        funcs.put(func.getFunctionName(), func);
        func = new LocaleFunction();
        funcs.put(func.getFunctionName(), func);
        func = new EqualsLocaleFunction();
        funcs.put(func.getFunctionName(), func);
        func = new MatchLocaleFunction();
        funcs.put(func.getFunctionName(), func);
        XPATH_FUNCTIONS = Collections.unmodifiableMap(funcs);
    }
}

