/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.xdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.outer_planes.jso.ExtensionNode;
import net.outer_planes.jso.x.xdata.AbstractFieldContainer;
import net.outer_planes.jso.x.xdata.FieldNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.jabberstudio.jso.x.xdata.XDataItem;
import org.jabberstudio.jso.x.xdata.XDataReported;

public class FormNode
extends ExtensionNode
implements XDataForm {
    public static final NSI ELEMNAME_TITLE = new NSI("title", "jabber:x:data");
    public static final NSI ELEMNAME_INSTRUCTIONS = new NSI("instructions", "jabber:x:data");
    public static final NSI ATTRNAME_TYPE = new NSI("type", null);

    public FormNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected FormNode(StreamElement parent, FormNode base) {
        super(parent, base);
    }

    public XDataForm.Type getType() {
        Object val = this.getAttributeObject(ATTRNAME_TYPE);
        XDataForm.Type type = null;
        if (val instanceof XDataForm.Type) {
            type = (XDataForm.Type)val;
        } else if (val != null) {
            String name = val.toString();
            if (Utilities.equateStrings(CANCEL.toString(), name)) {
                type = CANCEL;
            } else if (Utilities.equateStrings(FORM.toString(), name)) {
                type = FORM;
            } else if (Utilities.equateStrings(RESULT.toString(), name)) {
                type = RESULT;
            } else if (Utilities.equateStrings(SUBMIT.toString(), name)) {
                type = SUBMIT;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
            }
        }
        return type;
    }

    public void setType(XDataForm.Type type) {
        this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
    }

    public String getTitle() {
        StreamElement elem = this.getFirstElement(ELEMNAME_TITLE);
        return elem != null ? elem.normalizeTrimText() : "";
    }

    public void setTitle(String title) {
        StreamElement elem = this.getFirstElement(ELEMNAME_TITLE);
        if (Utilities.isValidString(title)) {
            if (elem != null) {
                elem.clearText();
            } else {
                elem = this.addElement(ELEMNAME_TITLE);
            }
            elem.addText(title);
        } else if (elem != null) {
            elem.detach();
        }
    }

    public List listInstructions() {
        List elems = this.listElements(ELEMNAME_INSTRUCTIONS);
        ArrayList<String> lines = new ArrayList<String>();
        Iterator itr = elems.iterator();
        while (itr.hasNext()) {
            lines.add(((StreamElement)itr.next()).normalizeTrimText());
        }
        return lines;
    }

    public void addInstruction(String inst) {
        StreamElement elem = this.addElement(ELEMNAME_INSTRUCTIONS);
        if (Utilities.isValidString(inst)) {
            elem.addText(inst);
        }
    }

    public void removeInstruction(String inst) {
        Iterator itr = this.listElements(ELEMNAME_INSTRUCTIONS).iterator();
        boolean removed = false;
        while (!removed && itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            String test = elem.normalizeTrimText();
            if (!Utilities.equateStrings(test, inst)) continue;
            elem.detach();
            removed = true;
        }
    }

    public void clearInstructions() {
        this.clearElements(ELEMNAME_INSTRUCTIONS);
    }

    public String getInstructions() {
        Iterator itr = this.listInstructions().iterator();
        StringBuffer buffer = new StringBuffer();
        String sep = System.getProperty("line.separator");
        while (itr.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(sep);
            }
            buffer.append(itr.next());
        }
        return buffer.toString();
    }

    public void setInstructions(String inst) {
        this.clearInstructions();
        if (Utilities.isValidString(inst)) {
            Iterator<String> itr = Arrays.asList(inst.split(System.getProperty("line.separator"), -1)).iterator();
            while (itr.hasNext()) {
                String line = itr.next().trim();
                StreamElement elem = this.addElement(ELEMNAME_INSTRUCTIONS);
                if (!Utilities.isValidString(line)) continue;
                elem.addText(line);
            }
        }
    }

    public XDataReported getReported() {
        return (XDataReported)this.getFirstElement(XDataReported.class);
    }

    public XDataReported addReported() {
        XDataReported report = this.getReported();
        if (report == null) {
            report = (XDataReported)this.addElement(XDataReported.NAME, XDataReported.class);
        }
        return report;
    }

    public void removeReported() {
        this.clearElements(XDataReported.class);
    }

    public List listItems() {
        return this.listElements(XDataItem.class);
    }

    public XDataItem addItem() {
        return (XDataItem)this.addElement(XDataItem.NAME, XDataItem.class);
    }

    public void clearItems() {
        this.clearElements(XDataItem.class);
    }

    public List listFields() {
        return this.listElements(XDataField.class);
    }

    public XDataField getField(String var) throws IllegalArgumentException {
        XDataField field = null;
        if (!Utilities.isValidString(var)) {
            throw new IllegalArgumentException("var cannot be null or \"\"");
        }
        try {
            field = (XDataField)this.select("xdata:field[(@var='" + var + "') and implements-class('org.jabberstudio.jso.x.xdata.XDataField')]", AbstractFieldContainer.NSS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return field;
    }

    public XDataField addField(String var) throws IllegalArgumentException, IllegalStateException {
        return this.addField(var, null);
    }

    public XDataField addField(String var, XDataField.Type type) throws IllegalArgumentException {
        XDataField field = this.getField(var);
        if (type == null) {
            type = XDataField.TEXT_SINGLE;
        }
        if (field == null) {
            FieldNode temp = (FieldNode)this.addElement(XDataField.NAME, FieldNode.class);
            temp.setType(type);
            temp.setVar(var);
            field = temp;
        } else if (field.getType() != type) {
            throw new IllegalStateException("field with different type already exists for \"" + var + "\"");
        }
        return field;
    }

    public void removeField(String var) throws IllegalArgumentException {
        XDataField field = this.getField(var);
        if (field != null) {
            field.detach();
        }
    }

    public void clearFields() {
        this.clearElements(XDataField.class);
    }

    public List listFieldValues(String var) throws IllegalArgumentException {
        XDataField field = this.getField(var);
        return field != null ? field.listValues() : Collections.EMPTY_LIST;
    }

    public String getFieldValue(String var) throws IllegalArgumentException {
        XDataField field = this.getField(var);
        return field != null ? field.getValue() : null;
    }

    public XDataField addFixedField(String val) {
        XDataField field = (XDataField)this.addElement(XDataField.NAME, XDataField.class);
        field.setType(XDataField.FIXED);
        field.setValue(val == null ? "" : val);
        return field;
    }

    public StreamObject copy(StreamElement parent) {
        return new FormNode(parent, this);
    }
}

