/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.si;

import java.util.List;
import net.outer_planes.jso.ExtensionBuilder;
import net.outer_planes.jso.ExtensionNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.fneg.FeatureNegQuery;
import org.jabberstudio.jso.x.si.SIProfile;
import org.jabberstudio.jso.x.si.SIQuery;

public class SIQueryNode
extends ExtensionNode
implements SIQuery {
    public static final NSI ATTRNAME_MIME = new NSI("mime-type", null);
    public static final NSI ATTRNAME_PROFILE = new NSI("profile", null);
    public static final String FEATURE_METHOD = "stream-method";

    public SIQueryNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected SIQueryNode(StreamElement parent, SIQueryNode base) {
        super(parent, base);
    }

    public StreamBuilder createBuilder() {
        return new ExtensionBuilder(this){

            protected StreamBuilder.Status processNestedElementStart(StreamParseState s) {
                StreamDataFactory sdf = s.getContext().getDataFactory();
                NSI name = s.getName();
                StreamBuilder.Status stat = EXTENDED_DATA;
                String profile = SIQueryNode.this.getAttributeValue(ATTRNAME_PROFILE);
                if (NSI.STRICT_COMPARATOR.compare(name, FeatureNegQuery.NAME) == 0) {
                    this.setExtendedData(sdf.createElementBuilder(name, class$org$jabberstudio$jso$x$fneg$FeatureNegQuery == null ? (class$org$jabberstudio$jso$x$fneg$FeatureNegQuery = SIQueryNode.class$("org.jabberstudio.jso.x.fneg.FeatureNegQuery")) : class$org$jabberstudio$jso$x$fneg$FeatureNegQuery));
                } else if (Utilities.isValidString(profile) && Utilities.equateStrings(name.getNamespaceURI(), profile)) {
                    this.setExtendedData(sdf.createElementBuilder(name, class$org$jabberstudio$jso$x$si$SIProfile == null ? (class$org$jabberstudio$jso$x$si$SIProfile = SIQueryNode.class$("org.jabberstudio.jso.x.si.SIProfile")) : class$org$jabberstudio$jso$x$si$SIProfile));
                } else {
                    stat = super.processNestedElementStart(s);
                }
                return stat;
            }
        };
    }

    public String getMimeType() {
        String mime = this.getAttributeValue(ATTRNAME_MIME);
        return mime != null ? mime : "";
    }

    public void setMimeType(String mime) {
        if (!Utilities.isValidString(mime)) {
            mime = null;
        }
        this.setAttributeValue(ATTRNAME_MIME, mime);
    }

    public SIProfile getProfile() {
        String name = this.getAttributeValue(ATTRNAME_PROFILE);
        StreamElement elem = Utilities.isValidString(name) ? this.getFirstElement(null, name) : null;
        SIProfile prof = null;
        if (elem != null) {
            if (elem instanceof SIProfile) {
                prof = (SIProfile)elem;
            } else {
                prof = (SIProfile)this.getDataFactory().createElementNode(elem.getNSI(), SIProfile.class);
                prof.reset(elem);
                this.insert(this.indexOf(elem), prof);
                elem.detach();
            }
        }
        return prof;
    }

    public void setProfile(SIProfile prof) {
        this.clearElements(SIProfile.class);
        this.add(prof);
    }

    public SIProfile applyProfile(NSI name) throws IllegalArgumentException {
        return this.applyProfile(name, null);
    }

    public SIProfile applyProfile(NSI name, Class iface) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Local-name cannot be null or \"\"");
        }
        if (!Utilities.isValidString(name.getNamespaceURI())) {
            throw new IllegalArgumentException("Namespace URI cannot be null or \"\"");
        }
        if (iface == null) {
            iface = SIProfile.class;
        } else if (!SIProfile.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Interface must be null or a superclass of SIProfile");
        }
        SIProfile profile = (SIProfile)this.addElement(name, iface);
        return profile;
    }

    public FeatureNegQuery getStreamMethodNegotiation() {
        FeatureNegQuery fneg = (FeatureNegQuery)this.getFirstElement(FeatureNegQuery.class);
        if (fneg == null) {
            fneg = (FeatureNegQuery)this.addElement(FeatureNegQuery.NAME, FeatureNegQuery.class);
            fneg.putFeature(FEATURE_METHOD, null);
        }
        return fneg;
    }

    public List listSupportedStreamMethods() {
        return this.getStreamMethodNegotiation().getSupportedOptions(FEATURE_METHOD);
    }

    public void addSupportedStreamMethod(String method) {
        FeatureNegQuery fneg = this.getStreamMethodNegotiation();
        List supported = fneg.getSupportedOptions(FEATURE_METHOD);
        if (Utilities.isValidString(method) && !supported.contains(method)) {
            supported.add(method);
            fneg.putFeature(FEATURE_METHOD, supported);
        }
    }

    public void removeSupportedStreamMethod(String method) {
        FeatureNegQuery fneg = this.getStreamMethodNegotiation();
        List supported = fneg.getSupportedOptions(FEATURE_METHOD);
        if (Utilities.isValidString(method) && supported.contains(method)) {
            supported.remove(method);
            fneg.putFeature(FEATURE_METHOD, supported);
        }
    }

    public void clearSupportedStreamMethods() {
        this.getStreamMethodNegotiation().putFeature(FEATURE_METHOD, null);
    }

    public String getPreferredStreamMethod() {
        return this.getStreamMethodNegotiation().getPreferredOption(FEATURE_METHOD);
    }

    public void setPreferredStreamMethod(String method) {
        this.getStreamMethodNegotiation().setPreferredOption(FEATURE_METHOD, method);
    }

    public void add(StreamNode node) {
        if (node instanceof SIProfile) {
            SIProfile prof = (SIProfile)node;
            this.setAttributeValue(ATTRNAME_PROFILE, prof.getNamespaceURI());
        }
        super.add(node);
    }

    public void insert(int idx, StreamNode node) {
        if (node instanceof SIProfile) {
            SIProfile prof = (SIProfile)node;
            this.setAttributeValue(ATTRNAME_PROFILE, prof.getNamespaceURI());
        }
        super.insert(idx, node);
    }

    public void remove(StreamNode node) {
        if (node instanceof SIProfile) {
            SIProfile prof = (SIProfile)node;
            this.setAttributeValue(ATTRNAME_PROFILE, null);
        }
        super.remove(node);
    }

    public StreamObject copy(StreamElement parent) {
        return new SIQueryNode(parent, this);
    }
}

