/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.disco;

import java.util.Iterator;
import java.util.List;
import net.outer_planes.jso.ExtensionNode;
import net.outer_planes.jso.x.disco.ItemNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.disco.DiscoItem;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.disco.DiscoUtilities;

public class ItemsNode
extends ExtensionNode
implements DiscoItemsQuery {
    public ItemsNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected ItemsNode(StreamElement parent, ItemsNode base) {
        super(parent, base);
    }

    public String getNode() {
        String node = this.getAttributeValue(DiscoUtilities.ATTRNAME_NODE);
        return Utilities.isValidString(node) ? node : "";
    }

    public void setNode(String node) {
        this.setAttributeValue(DiscoUtilities.ATTRNAME_NODE, node);
    }

    public StreamObject copy(StreamElement parent) {
        return new ItemsNode(parent, this);
    }

    public List listItems() {
        return this.listElements(DiscoItem.class);
    }

    public DiscoItem getItem(JID jid) throws IllegalArgumentException {
        return this.getItem(jid, null);
    }

    public DiscoItem getItem(JID jid, String node) throws IllegalArgumentException {
        DiscoItem item = null;
        if (jid == null) {
            throw new IllegalArgumentException("JID cannot be null");
        }
        if (node == null) {
            node = "";
        }
        Iterator itr = this.listItems().iterator();
        while (item == null && itr.hasNext()) {
            DiscoItem temp = (DiscoItem)itr.next();
            if (JID.STRICT_COMPARATOR.compare(temp.getJID(), jid) != 0 || !Utilities.equateStrings(temp.getNode(), node)) continue;
            item = temp;
        }
        return item;
    }

    public DiscoItem addItem(JID jid) throws IllegalArgumentException {
        return this.addItem(jid, null, null);
    }

    public DiscoItem addItem(JID jid, String node) throws IllegalArgumentException {
        return this.addItem(jid, node, null);
    }

    public DiscoItem addItem(JID jid, String node, String name) throws IllegalArgumentException {
        DiscoItem item = this.getItem(jid, node);
        if (item == null) {
            ItemNode temp = (ItemNode)this.addElement(ItemNode.NAME, ItemNode.class);
            temp.setJID(jid);
            temp.setNode(node);
            temp.setName(name);
            item = temp;
        }
        return item;
    }

    public void removeItem(JID jid) throws IllegalArgumentException {
        this.removeItem(jid, null);
    }

    public void removeItem(JID jid, String node) throws IllegalArgumentException {
        DiscoItem item = this.getItem(jid, node);
        if (item != null) {
            item.detach();
        }
    }

    public void clearItems() {
        this.clearElements(DiscoItem.class);
    }
}

