/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.outer_planes.jso.ElementNode;
import net.outer_planes.jso.ExtensionNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.core.RosterExtension;
import org.jabberstudio.jso.x.core.RosterItem;
import org.jabberstudio.jso.x.core.RosterQuery;

public class RosterNode
extends ExtensionNode
implements RosterQuery,
RosterExtension {
    public RosterNode(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    public RosterNode(StreamElement p, RosterNode base) {
        super(p, base);
    }

    public static RosterNode createRosterQuery(StreamDataFactory sdf) {
        return new RosterNode(sdf, new NSI("query", "jabber:iq:roster"));
    }

    public static RosterNode createRosterExtension(StreamDataFactory sdf) {
        return new RosterNode(sdf, new NSI("x", "jabber:x:roster"));
    }

    public RosterItem getItem(JID jid) {
        Iterator items = this.listElements(Item.class).iterator();
        RosterItem item = null;
        if (jid == null) {
            throw new IllegalArgumentException("JID cannot be null");
        }
        while (items.hasNext() && item == null) {
            RosterItem test = (RosterItem)items.next();
            if (!test.getJID().equals(jid)) continue;
            item = test;
        }
        return item;
    }

    public RosterItem createItem(JID jid) {
        RosterItem item = this.getItem(jid);
        if (item == null) {
            Item nativeItem = new Item(this.getDataFactory());
            nativeItem.setJID(jid);
            this.add(nativeItem);
            item = nativeItem;
        }
        return item;
    }

    public StreamObject copy(StreamElement parent) {
        return new RosterNode(parent, this);
    }

    public static class Item
    extends ElementNode
    implements RosterItem {
        public static final NSI NAME = new NSI("item", null);
        public static final NSI ATTR_JID = new NSI("jid", null);
        public static final NSI ATTR_NAME = new NSI("name", null);
        public static final NSI ATTR_SUBSCRIPTION = new NSI("subscription", null);
        public static final NSI ATTR_ASK = new NSI("ask", null);

        public Item(StreamDataFactory sdf) {
            super(sdf, NAME);
        }

        public Item(StreamDataFactory sdf, NSI name) {
            super(sdf, name);
        }

        public Item(StreamElement parent, Item base) {
            super(parent, base);
        }

        public JID getJID() {
            Object val = this.getAttributeObject(ATTR_JID);
            JID jid = null;
            if (val instanceof JID) {
                jid = (JID)val;
            } else if (val != null) {
                try {
                    jid = JID.valueOf(val);
                    this.setAttributeObject(ATTR_JID, (Object)jid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return jid;
        }

        public void setJID(JID jid) throws IllegalArgumentException {
            if (jid == null) {
                throw new IllegalArgumentException("JID cannot be null");
            }
            this.setAttributeObject(ATTR_JID, (Object)jid);
        }

        public String getDisplayName() {
            String val = this.getAttributeValue(ATTR_NAME);
            return val != null ? val : "";
        }

        public void setDisplayName(String name) {
            this.setAttributeValue(ATTR_NAME, Utilities.isValidString(name) ? name : null);
        }

        public boolean isAskSubscribe() {
            String val = this.getAttributeValue(ATTR_ASK);
            return Utilities.equateStrings("subscribe", val);
        }

        public void setAskSubscribe(boolean sub) {
            String val = sub ? "subscribe" : null;
            this.setAttributeValue(ATTR_ASK, val);
        }

        public boolean isAskUnsubscribe() {
            String val = this.getAttributeValue(ATTR_ASK);
            return Utilities.equateStrings("unsubscribe", val);
        }

        public void setAskUnsubscribe(boolean unsub) {
            String val = unsub ? "unsubscribe" : null;
            this.setAttributeValue(ATTR_ASK, val);
        }

        public RosterItem.SubscriptionType getSubscription() {
            Object val = this.getAttributeObject(ATTR_SUBSCRIPTION);
            RosterItem.SubscriptionType type = NONE;
            if (val instanceof RosterItem.SubscriptionType) {
                type = (RosterItem.SubscriptionType)val;
            } else if (val != null) {
                String str = val.toString();
                if (Utilities.equateStrings(TO.toString(), str)) {
                    type = TO;
                } else if (Utilities.equateStrings(FROM.toString(), str)) {
                    type = FROM;
                } else if (Utilities.equateStrings(BOTH.toString(), str)) {
                    type = BOTH;
                } else if (Utilities.equateStrings(REMOVE.toString(), str)) {
                    type = REMOVE;
                }
                if (type != null) {
                    this.setAttributeObject(ATTR_SUBSCRIPTION, (Object)type);
                }
            }
            return type;
        }

        public void setSubscription(RosterItem.SubscriptionType type) {
            if (type == null) {
                type = NONE;
            }
            this.setAttributeObject(ATTR_SUBSCRIPTION, (Object)type);
        }

        public String[] getGroups() {
            LinkedList<String> grpList = new LinkedList<String>();
            Iterator grpItr = this.listElements("group").iterator();
            while (grpItr.hasNext()) {
                StreamElement grp = (StreamElement)grpItr.next();
                grpList.add(grp.normalizeTrimText());
            }
            String[] grpArr = new String[grpList.size()];
            grpArr = grpList.toArray(grpArr);
            return grpArr;
        }

        public void setGroups(String[] grps) {
            NSI grpName = new NSI("group", null);
            Iterator prevGrps = this.listElements(grpName).iterator();
            if (grps == null) {
                grps = new String[]{};
            }
            while (prevGrps.hasNext()) {
                ((StreamElement)prevGrps.next()).detach();
            }
            for (int idx = 0; idx < grps.length; ++idx) {
                this.addElement(grpName).addText(grps[idx]);
            }
        }

        protected StreamElement getGroupElement(String grp) {
            Iterator itr = this.listElements("group").iterator();
            StreamElement found = null;
            while (found == null && itr.hasNext()) {
                found = (StreamElement)itr.next();
                if (Utilities.equateStrings(found.normalizeTrimText(), grp)) continue;
                found = null;
            }
            return found;
        }

        public List listGroups() {
            LinkedList<String> grpList = new LinkedList<String>();
            Iterator grpItr = this.listElements("group").iterator();
            while (grpItr.hasNext()) {
                StreamElement grp = (StreamElement)grpItr.next();
                grpList.add(grp.normalizeTrimText());
            }
            return grpList;
        }

        public void addGroup(String grp) {
            StreamElement elem;
            if (Utilities.isValidString(grp) && (elem = this.getGroupElement(grp)) == null) {
                this.addElement("group").addText(grp);
            }
        }

        public void removeGroup(String grp) {
            StreamElement elem;
            if (Utilities.isValidString(grp) && (elem = this.getGroupElement(grp)) != null) {
                elem.detach();
            }
        }

        public void clearGroups() {
            this.clearElements("group");
        }

        public StreamObject copy(StreamElement parent) {
            return new Item(parent, this);
        }
    }
}

