/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.core;

import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.core.PrivacyItem;
import org.jabberstudio.jso.x.core.RosterItem;

public class PrivacyItemNode
extends ElementNode
implements PrivacyItem {
    public static final NSI ATTRNAME_ACTION = new NSI("action", null);
    public static final NSI ATTRNAME_TYPE = new NSI("type", null);
    public static final NSI ATTRNAME_ORDER = new NSI("order", null);
    public static final NSI ATTRNAME_VALUE = new NSI("value", null);
    public static final NSI ELEMNAME_IQ = new NSI("iq", "jabber:iq:privacy");
    public static final NSI ELEMNAME_MESSAGE = new NSI("message", "jabber:iq:privacy");
    public static final NSI ELEMNAME_PRESENCE_IN = new NSI("presence-in", "jabber:iq:privacy");
    public static final NSI ELEMNAME_PRESENCE_OUT = new NSI("presence-out", "jabber:iq:privacy");

    public PrivacyItemNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected PrivacyItemNode(StreamElement parent, PrivacyItemNode base) {
        super(parent, base);
    }

    public PrivacyItem.Action getAction() {
        Object val = this.getAttributeObject(ATTRNAME_ACTION);
        PrivacyItem.Action act = null;
        if (val instanceof PrivacyItem.Action) {
            act = (PrivacyItem.Action)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(temp, ALLOW.toString())) {
                act = ALLOW;
            } else if (Utilities.equateStrings(temp, DENY.toString())) {
                act = DENY;
            }
            if (act != null) {
                this.setAttributeObject(ATTRNAME_ACTION, (Object)act);
            }
        }
        return act;
    }

    public void setAction(PrivacyItem.Action act) {
        this.setAttributeObject(ATTRNAME_ACTION, (Object)act);
    }

    public PrivacyItem.Type getType() {
        Object val = this.getAttributeObject(ATTRNAME_TYPE);
        PrivacyItem.Type type = null;
        if (val instanceof PrivacyItem.Type) {
            type = (PrivacyItem.Type)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(temp, JID.toString())) {
                type = JID;
            } else if (Utilities.equateStrings(temp, GROUP.toString())) {
                type = GROUP;
            } else if (Utilities.equateStrings(temp, SUBSCRIPTION.toString())) {
                type = SUBSCRIPTION;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
            }
        }
        return type;
    }

    public void setType(PrivacyItem.Type type) {
        this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
    }

    public int getOrder() {
        Object val = this.getAttributeObject(ATTRNAME_ORDER);
        int order = 0;
        if (val instanceof Number) {
            order = ((Number)val).intValue();
        } else if (val != null) {
            Integer temp = null;
            try {
                temp = Integer.valueOf(val.toString());
                order = temp;
                this.setAttributeObject(ATTRNAME_ORDER, (Object)temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return order;
    }

    public void setOrder(int order) throws IllegalArgumentException {
        if (order < 0) {
            throw new IllegalArgumentException("order cannot be less than 0");
        }
        this.setAttributeObject(ATTRNAME_ORDER, (Object)new Integer(order));
    }

    public String getValue() {
        String val = this.getAttributeValue(ATTRNAME_VALUE);
        return val != null ? val : "";
    }

    public void setValue(String val) {
        this.setAttributeValue(ATTRNAME_VALUE, Utilities.isValidString(val) ? val : null);
    }

    public JID getJIDValue() throws IllegalStateException {
        Object val = this.getAttributeObject(ATTRNAME_VALUE);
        JID jid = null;
        if (this.getType() != JID) {
            throw new IllegalStateException("Type must be JID");
        }
        if (val instanceof JID) {
            jid = (JID)val;
        } else if (val != null) {
            try {
                jid = new JID(val);
                this.setAttributeObject(ATTRNAME_VALUE, (Object)jid);
            }
            catch (JIDFormatException jIDFormatException) {
                // empty catch block
            }
        }
        return jid;
    }

    public void setJIDValue(JID val) {
        this.setType(JID);
        this.setAttributeObject(ATTRNAME_VALUE, (Object)val);
    }

    public String getGroupValue() throws IllegalStateException {
        if (this.getType() != GROUP) {
            throw new IllegalStateException("Type must be GROUP");
        }
        return this.getValue();
    }

    public void setGroupValue(String val) {
        this.setType(GROUP);
        this.setValue(val);
    }

    public RosterItem.SubscriptionType getSubscriptionValue() throws IllegalStateException {
        Object val = this.getAttributeObject(ATTRNAME_VALUE);
        RosterItem.SubscriptionType type = null;
        if (this.getType() != SUBSCRIPTION) {
            throw new IllegalStateException("Type must be SUBSCRIPTION");
        }
        if (val instanceof RosterItem.SubscriptionType) {
            type = (RosterItem.SubscriptionType)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(temp, RosterItem.BOTH.toString())) {
                type = RosterItem.BOTH;
            } else if (Utilities.equateStrings(temp, RosterItem.FROM.toString())) {
                type = RosterItem.FROM;
            } else if (Utilities.equateStrings(temp, RosterItem.NONE.toString())) {
                type = RosterItem.NONE;
            } else if (Utilities.equateStrings(temp, RosterItem.TO.toString())) {
                type = RosterItem.TO;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_VALUE, (Object)type);
            }
        }
        return type;
    }

    public void setSubscriptionValue(RosterItem.SubscriptionType val) {
        this.setType(SUBSCRIPTION);
        this.setAttributeObject(ATTRNAME_VALUE, (Object)val);
    }

    public boolean isAppliedToIQ() {
        return this.getFirstElement(ELEMNAME_IQ) != null;
    }

    public void setAppliedToIQ(boolean block) {
        StreamElement elem = this.getFirstElement(ELEMNAME_IQ);
        if (block && elem == null) {
            elem = this.addElement(ELEMNAME_IQ);
        } else if (!block && elem != null) {
            elem.detach();
        }
    }

    public boolean isAppliedToMessage() {
        return this.getFirstElement(ELEMNAME_MESSAGE) != null;
    }

    public void setAppliedToMessage(boolean block) {
        StreamElement elem = this.getFirstElement(ELEMNAME_MESSAGE);
        if (block && elem == null) {
            elem = this.addElement(ELEMNAME_MESSAGE);
        } else if (!block && elem != null) {
            elem.detach();
        }
    }

    public boolean isAppliedToPresenceIn() {
        return this.getFirstElement(ELEMNAME_PRESENCE_IN) != null;
    }

    public void setAppliedToPresenceIn(boolean block) {
        StreamElement elem = this.getFirstElement(ELEMNAME_PRESENCE_IN);
        if (block && elem == null) {
            elem = this.addElement(ELEMNAME_PRESENCE_IN);
        } else if (!block && elem != null) {
            elem.detach();
        }
    }

    public boolean isAppliedToPresenceOut() {
        return this.getFirstElement(ELEMNAME_PRESENCE_OUT) != null;
    }

    public void setAppliedToPresenceOut(boolean block) {
        StreamElement elem = this.getFirstElement(ELEMNAME_PRESENCE_OUT);
        if (block && elem == null) {
            elem = this.addElement(ELEMNAME_PRESENCE_OUT);
        } else if (!block && elem != null) {
            elem.detach();
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new PrivacyItemNode(parent, this);
    }
}

