/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.commands;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.outer_planes.jso.ExtensionNode;
import net.outer_planes.jso.x.commands.CommandNoteNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.commands.CommandActions;
import org.jabberstudio.jso.x.commands.CommandNote;
import org.jabberstudio.jso.x.commands.CommandQuery;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class CommandQueryNode
extends ExtensionNode
implements CommandQuery {
    public static final NSI ATTRNAME_ACTION = new NSI("action", null);
    public static final NSI ATTRNAME_STATUS = new NSI("status", null);
    public static final NSI ATTRNAME_NODE = new NSI("node", null);
    public static final NSI ATTRNAME_SESSIONID = new NSI("sessionid", null);
    private static XPath _InfoPath;
    private static XPath _PayloadPath;

    public CommandQueryNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected CommandQueryNode(StreamElement parent, CommandQueryNode base) {
        super(parent, base);
    }

    protected XPath getNoteXPath() {
        if (_InfoPath == null) {
            try {
                TreeMap<String, String> nss = new TreeMap<String, String>();
                nss.put("cmd", "http://jabber.org/protocol/commands");
                _InfoPath = this.getDataFactory().createXPath("cmd:note[@type=$type]", nss);
                _InfoPath.setVariableContext((VariableContext)new SimpleVariableContext());
            }
            catch (SAXPathException sAXPathException) {
                // empty catch block
            }
        }
        return _InfoPath;
    }

    protected XPath getPayloadXPath() {
        if (_PayloadPath == null) {
            try {
                _PayloadPath = this.getDataFactory().createXPath("*[namespace-uri()!='http://jabber.org/protocol/commands']");
            }
            catch (SAXPathException sAXPathException) {
                // empty catch block
            }
        }
        return _PayloadPath;
    }

    public StreamObject copy(StreamElement parent) {
        return new CommandQueryNode(parent, this);
    }

    public String getNode() {
        String node = this.getAttributeValue(ATTRNAME_NODE);
        return node != null ? node : "";
    }

    public void setNode(String node) {
        this.setAttributeValue(ATTRNAME_NODE, Utilities.isValidString(node) ? node : null);
    }

    public String getSessionID() {
        String id = this.getAttributeValue(ATTRNAME_SESSIONID);
        return id != null ? id : "";
    }

    public void setSessionID(String id) {
        this.setAttributeValue(ATTRNAME_SESSIONID, Utilities.isValidString(id) ? id : null);
    }

    public CommandQuery.Action getAction() {
        Object val = this.getAttributeObject(ATTRNAME_ACTION);
        CommandQuery.Action act = null;
        if (val instanceof CommandQuery.Action) {
            act = (CommandQuery.Action)val;
        } else if (val != null && (act = CommandQueryNode.toAction(val.toString())) != null) {
            this.setAction(act);
        }
        return act;
    }

    public void setAction(CommandQuery.Action act) {
        this.setAttributeObject(ATTRNAME_ACTION, (Object)act);
    }

    public CommandQuery.Status getStatus() {
        Object val = this.getAttributeObject(ATTRNAME_STATUS);
        CommandQuery.Status stat = null;
        if (val instanceof CommandQuery.Status) {
            stat = (CommandQuery.Status)val;
        } else if (val != null) {
            String name = val.toString();
            if (Utilities.equateStrings(CANCELED.toString(), name)) {
                stat = CANCELED;
            } else if (Utilities.equateStrings(COMPLETED.toString(), name)) {
                stat = COMPLETED;
            } else if (Utilities.equateStrings(EXECUTING.toString(), name)) {
                stat = EXECUTING;
            }
            if (stat != null) {
                this.setStatus(stat);
            }
        }
        return stat;
    }

    public void setStatus(CommandQuery.Status stat) {
        this.setAttributeObject(ATTRNAME_STATUS, (Object)stat);
    }

    public CommandActions getActionInfo() {
        CommandActions acts = (CommandActions)this.getFirstElement(CommandActions.class);
        if (acts == null) {
            acts = (CommandActions)this.addElement(CommandActions.NAME, CommandActions.class);
        }
        return acts;
    }

    public List listNotes() {
        return this.listElements(CommandNote.class);
    }

    public CommandNote addNote(CommandNote.Type type, String msg) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!Utilities.isValidString(msg)) {
            throw new IllegalArgumentException("message cannot be null or \"\"");
        }
        CommandNoteNode info = (CommandNoteNode)this.addElement(CommandNoteNode.NAME, CommandNoteNode.class);
        info.setType(type);
        info.setMessage(msg);
        return info;
    }

    public void clearNotes() {
        this.clearElements(CommandNote.class);
    }

    public List listNotes(CommandNote.Type type) {
        List infos = Collections.EMPTY_LIST;
        if (type != null) {
            try {
                XPath xpath = this.getNoteXPath();
                SimpleVariableContext varCtx = new SimpleVariableContext();
                varCtx.setVariableValue("type", (Object)type.toString());
                xpath.setVariableContext((VariableContext)varCtx);
                infos = xpath.selectNodes((Object)this);
            }
            catch (JaxenException je) {}
        } else {
            infos = this.listNotes();
        }
        return infos;
    }

    public void clearNotes(CommandNote.Type type) {
        if (type != null) {
            Iterator itr = this.listNotes(type).iterator();
            while (itr.hasNext()) {
                ((StreamElement)itr.next()).detach();
            }
        } else {
            this.clearNotes();
        }
    }

    public StreamElement getPayload() {
        StreamElement payload = null;
        try {
            payload = (StreamElement)this.getPayloadXPath().selectSingleNode((Object)this);
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return payload;
    }

    public void setPayload(StreamElement payload) {
        this.clearPayload();
        this.add(payload);
    }

    public List listPayload() {
        List payloads = Collections.EMPTY_LIST;
        try {
            payloads = this.getPayloadXPath().selectNodes((Object)this);
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return payloads;
    }

    public void clearPayload() {
        Iterator itr = this.listPayload().iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
    }

    public static CommandQuery.Action toAction(String name) {
        CommandQuery.Action act = null;
        if (Utilities.equateStrings(CANCEL.toString(), name)) {
            act = CANCEL;
        } else if (Utilities.equateStrings(COMPLETE.toString(), name)) {
            act = COMPLETE;
        } else if (Utilities.equateStrings(EXECUTE.toString(), name)) {
            act = EXECUTE;
        } else if (Utilities.equateStrings(NEXT.toString(), name)) {
            act = NEXT;
        } else if (Utilities.equateStrings(PREV.toString(), name)) {
            act = PREV;
        }
        return act;
    }
}

