/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl.mechanisms;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import net.outer_planes.jso.sasl.ServerMechanism;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLFailedException;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.sasl.SASLServerInfo;
import org.jabberstudio.jso.sasl.callback.ConfirmAuthorizationCallback;

public class ServerPLAINMechanism
extends ServerMechanism {
    public ServerPLAINMechanism(SASLServerInfo si) {
        super(si);
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    protected SASLPacket evaluateAuth(SASLAuthPacket auth) throws IllegalStateException, SASLFailedException {
        SASLPacket output = super.evaluateAuth(auth);
        byte[] data = auth.getData();
        if (data.length > 0) {
            output = this.evaluatePlain(data);
        }
        return output;
    }

    protected SASLPacket evaluateResponse(SASLPacket resp) throws IllegalStateException, SASLFailedException {
        return this.evaluatePlain(resp.getData());
    }

    private final SASLPacket evaluatePlain(byte[] data) throws IllegalStateException, SASLFailedException {
        SASLPacket output = null;
        Map params = this.readParameters(data);
        ArrayList<Callback> calls = new ArrayList<Callback>();
        CallbackHandler cbh = this.getCallbackHandler();
        if (cbh != null) {
            String expectedPass;
            NameCallback nc = null;
            PasswordCallback pc = null;
            Object cac = null;
            Object user = params.get("javax.security.sasl.username");
            Object pass = params.get("javax.security.sasl.password");
            Object authz = params.get("javax.security.sasl.authzid");
            Object authn = null;
            try {
                nc = new NameCallback("username", (String)user);
                calls.add(nc);
                pc = new PasswordCallback("password", false);
                calls.add(pc);
                if (authz != null) {
                    calls.add(new ConfirmAuthorizationCallback(authn, (JID)authz));
                }
                cbh.handle(calls.toArray(new Callback[calls.size()]));
            }
            catch (ClassCastException cce) {
                throw this.completeFailure("invalid-authzid");
            }
            catch (Exception e) {
                throw this.completeFailure("temporary-auth-failure");
            }
            String actualPass = pass != null ? pass.toString() : "";
            String string = expectedPass = pc.getPassword() != null ? new String(pc.getPassword()) : "";
            if (!actualPass.equals(expectedPass)) {
                throw this.completeFailure("not-authorized");
            }
        } else {
            throw this.completeFailure("temporary-auth-failure");
        }
        this.completeSuccess((SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_SUCCESS));
        return output;
    }

    private final Map readParameters(byte[] input) throws SASLFailedException {
        try {
            String[] data = new String(input, "UTF-8").split("\u0000");
            block7: for (int idx = 0; idx < data.length; ++idx) {
                switch (idx) {
                    case 0: {
                        this.setProperty("javax.security.sasl.authzid", data[idx]);
                        continue block7;
                    }
                    case 1: {
                        this.setProperty("javax.security.sasl.username", data[idx]);
                        continue block7;
                    }
                    case 2: {
                        this.setProperty("javax.security.sasl.password", data[idx]);
                    }
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw this.completeFailure("incorrect-encoding");
        }
        return this.getProperties();
    }
}

