/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl.mechanisms;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import net.outer_planes.jso.sasl.AbstractMechanismProvider;
import net.outer_planes.jso.sasl.ClientMechanism;
import net.outer_planes.jso.sasl.mechanisms.MD5MessageCodec;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.sasl.callback.AuthorizationIDCallback;
import org.jabberstudio.jso.sasl.callback.RealmInputCallback;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.DigestHash;
import org.jabberstudio.jso.util.Utilities;

public class ClientDigestMD5Mechanism
extends ClientMechanism {
    public static final SASLMechanism.Status AUTHENTICATING_MORE = new MD5Status("final challenge", true, false);
    public static final String NAME = "DIGEST-MD5";
    public static final String CB_AUTHZID = "authzid";
    public static final String CB_REALM = "realm";
    public static final String CB_USERNAME = "username";
    public static final String CB_PASSWORD = "password";
    public static final String CB_DOMAIN = "domain";
    public static final String CB_SERVER = "server-name";
    public static final int DEFAULT_MAXBUFFER = 65536;
    public static final Map POLICY;
    private int _ChallengeState = 0;

    public ClientDigestMD5Mechanism(SASLClientInfo ci) {
        super(ci);
    }

    public String getMechanismName() {
        return NAME;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] toBytes(String s) {
        void var1_1;
        byte[] sb;
        if (s == null) {
            sb = new byte[]{};
        } else {
            try {
                sb = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 is not a supported encoding");
            }
        }
        return var1_1;
    }

    private static final String toHex(byte[] hash) {
        return ByteCodec.HEX.encode(hash);
    }

    private static final byte[] H(String s) {
        return ClientDigestMD5Mechanism.H(ClientDigestMD5Mechanism.toBytes(s));
    }

    private static final byte[] H(byte[] s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(s);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 is not a supported hashing algorithm");
        }
    }

    private static final byte[] H(byte[] one, byte[] two) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(one);
            return md.digest(two);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"MD5 not found");
        }
    }

    private static final byte[] KD(String k, String s) {
        return ClientDigestMD5Mechanism.H(k + ":" + s);
    }

    private static final byte[] HMAC(String k, String s) {
        int B = 64;
        if (s == null) {
            s = "";
        }
        byte[] kb = ClientDigestMD5Mechanism.toBytes(k);
        byte[] sb = ClientDigestMD5Mechanism.toBytes(s);
        if (kb.length > B) {
            kb = ClientDigestMD5Mechanism.H(kb);
        }
        byte[] k_ipad = new byte[B];
        byte[] k_opad = new byte[B];
        for (int i = 0; i < B; ++i) {
            k_ipad[i] = (byte)(kb[i] ^ 0x36);
            k_opad[i] = (byte)(kb[i] ^ 0x5C);
        }
        byte[] inner = ClientDigestMD5Mechanism.H(k_ipad, sb);
        return ClientDigestMD5Mechanism.H(k_opad, inner);
    }

    private static final byte[] A1(Properties cmap) {
        byte[] temp;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] colon = ClientDigestMD5Mechanism.toBytes(":");
        String realm = cmap.getProperty(CB_REALM, "");
        String user = cmap.getProperty(CB_USERNAME, "");
        String pass = cmap.getProperty(CB_PASSWORD, "");
        String azid = cmap.getProperty(CB_AUTHZID, "");
        String nonce = cmap.getProperty("nonce", "");
        String cnonce = cmap.getProperty("cnonce", "");
        if (!Utilities.isValidString(cnonce)) {
            temp = new byte[1024];
            new SecureRandom().nextBytes(temp);
            cnonce = ByteCodec.BASE64.encode(DigestHash.MD5.hashToBytes(ByteCodec.BASE64.encode(temp)));
            cmap.setProperty("cnonce", cnonce);
        }
        temp = ClientDigestMD5Mechanism.H(user + ":" + realm + ":" + pass);
        bout.write(temp, 0, temp.length);
        temp = ClientDigestMD5Mechanism.toBytes(nonce);
        bout.write(colon, 0, colon.length);
        bout.write(temp, 0, temp.length);
        temp = ClientDigestMD5Mechanism.toBytes(cnonce);
        bout.write(colon, 0, colon.length);
        bout.write(temp, 0, temp.length);
        if (Utilities.isValidString(azid)) {
            temp = ClientDigestMD5Mechanism.toBytes(azid.toString());
            bout.write(colon, 0, colon.length);
            bout.write(temp, 0, temp.length);
        }
        return bout.toByteArray();
    }

    private static final String A2(Properties cmap) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StringBuffer uri = new StringBuffer();
        StringBuffer retval = new StringBuffer();
        String domain = cmap.getProperty("host", "");
        String server = cmap.getProperty("serv-name", "");
        String qop = cmap.getProperty("qop", "auth");
        uri.append("xmpp").append("/").append(domain);
        if (Utilities.isValidString(server) && !Utilities.equateStrings(domain, server)) {
            uri.append("/").append(server);
        }
        cmap.setProperty("digest-uri", uri.toString());
        retval.append("AUTHENTICATE:").append(uri);
        if (!Utilities.equateStrings(qop, "auth")) {
            retval.append(":00000000000000000000000000000000");
        }
        return retval.toString();
    }

    private static final String RESP(Properties cmap) {
        StringBuffer s = new StringBuffer();
        String nc = "00000001";
        cmap.setProperty("nc", nc);
        String a1 = ClientDigestMD5Mechanism.toHex(ClientDigestMD5Mechanism.H(ClientDigestMD5Mechanism.A1(cmap)));
        String a2 = ClientDigestMD5Mechanism.toHex(ClientDigestMD5Mechanism.H(ClientDigestMD5Mechanism.A2(cmap)));
        String nonce = cmap.getProperty("nonce", "");
        String cnonce = cmap.getProperty("cnonce", "");
        String qop = cmap.getProperty("qop", "auth");
        s.append(nonce).append(":").append(nc);
        s.append(":").append(cnonce);
        s.append(":").append(qop);
        s.append(":").append(a2);
        byte[] kd = ClientDigestMD5Mechanism.KD(a1, s.toString());
        return ClientDigestMD5Mechanism.toHex(kd);
    }

    protected boolean isQOPSupported(Properties cmap) {
        boolean supported = false;
        String qop = cmap.getProperty("qop", "auth");
        if (!Utilities.isValidString(qop)) {
            supported = true;
        } else {
            String[] qopOpts = qop.split(",");
            for (int idx = 0; !supported && idx < qopOpts.length; ++idx) {
                String opt = qopOpts[idx].trim();
                supported = Utilities.equateStrings(opt, "auth");
            }
        }
        if (supported) {
            cmap.setProperty("qop", "auth");
        }
        return supported;
    }

    protected boolean configureMaxBuffer(Properties cmap) {
        String val = cmap.getProperty("maxbuf", Integer.toString(65536));
        boolean configed = true;
        if (!Utilities.isValidString(val)) {
            try {
                int maxbuf = Integer.parseInt(val);
                cmap.setProperty("maxbuf", Integer.toString(maxbuf));
            }
            catch (NumberFormatException nfe) {
                configed = false;
            }
        }
        return configed;
    }

    protected SASLPacket generateAuth() {
        SASLAuthPacket sasl = (SASLAuthPacket)this.getDataFactory().createPacketNode(SASLAuthPacket.NAME, SASLAuthPacket.class);
        sasl.setMechanismName(this.getMechanismName());
        this.setCurrentStatus(AUTHENTICATING);
        return sasl;
    }

    protected SASLPacket evaluateChallenge(SASLPacket challenge) {
        StreamDataFactory sdf = this.getDataFactory();
        SASLPacket resp = null;
        SASLMechanism.Status current = this.getCurrentStatus();
        Properties cmap = MD5MessageCodec.decode(challenge.getData());
        resp = current == AUTHENTICATING ? this.evaluateInitialChallenge(cmap) : (current == AUTHENTICATING_MORE ? this.evaluateNextChallenge(cmap) : (SASLPacket)sdf.createPacketNode(SASLPacket.NAME_ABORT, SASLPacket.class));
        return resp;
    }

    private final SASLPacket evaluateInitialChallenge(Properties cmap) {
        SASLPacket output = null;
        String qop = "auth";
        LinkedList<Callback> calls = new LinkedList<Callback>();
        JID azid = this.getAuthorizationID();
        CallbackHandler cbh = this.getCallbackHandler();
        Object user = this.getProperty("javax.security.sasl.username");
        Object pass = this.getProperty("javax.security.sasl.password");
        Object domain = this.getProperty("javax.security.sasl.domain");
        Object server = this.getProperty("javax.security.sasl.server");
        String realm = cmap.getProperty(CB_REALM);
        String nonce = cmap.getProperty("nonce");
        if (domain == null) {
            domain = this.getServer();
        }
        if (server == null) {
            server = this.getServer();
        }
        if (cbh != null) {
            if (azid == null) {
                calls.add(new AuthorizationIDCallback(CB_AUTHZID));
            }
            if (user == null) {
                calls.add(new NameCallback(CB_USERNAME));
            }
            if (pass == null) {
                calls.add(new PasswordCallback(CB_PASSWORD, false));
            }
            if (domain == null) {
                calls.add(new TextInputCallback(CB_DOMAIN));
            }
            if (server == null) {
                calls.add(new TextInputCallback(CB_SERVER));
            }
            if (realm == null) {
                calls.add(new RealmInputCallback(CB_REALM));
            }
            if (!calls.isEmpty()) {
                try {
                    Callback[] cbs = calls.toArray(new Callback[calls.size()]);
                    cbh.handle(cbs);
                    Iterator itr = calls.iterator();
                    while (itr.hasNext()) {
                        Callback cb = (Callback)itr.next();
                        if (cb instanceof NameCallback) {
                            user = ((NameCallback)cb).getName();
                            continue;
                        }
                        if (cb instanceof PasswordCallback) {
                            pass = new String(((PasswordCallback)cb).getPassword());
                            continue;
                        }
                        if (cb instanceof AuthorizationIDCallback) {
                            azid = ((AuthorizationIDCallback)cb).getAuthorizationID();
                            continue;
                        }
                        if (cb instanceof TextInputCallback) {
                            TextInputCallback ticb = (TextInputCallback)cb;
                            String prompt = ticb.getPrompt();
                            if (Utilities.equateStrings(prompt, CB_DOMAIN)) {
                                domain = ticb.getText();
                                continue;
                            }
                            if (!Utilities.equateStrings(prompt, CB_SERVER)) continue;
                            server = ticb.getText();
                            continue;
                        }
                        if (!(cb instanceof RealmInputCallback)) continue;
                        realm = ((RealmInputCallback)cb).getRealm();
                    }
                }
                catch (Exception e) {
                    this.obtainLogger().warn((Object)"Could not process all calbacks", (Throwable)e);
                    output = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_ABORT, SASLPacket.class);
                }
            }
        }
        if (!this.isQOPSupported(cmap)) {
            this.obtainLogger().warn((Object)"Requested qop not supported");
            output = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_ABORT, SASLPacket.class);
            return output;
        }
        if (!this.configureMaxBuffer(cmap)) {
            this.obtainLogger().warn((Object)"Requested maxbuf not correct");
            output = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_ABORT, SASLPacket.class);
        }
        cmap.setProperty(CB_USERNAME, user != null ? user.toString() : "");
        cmap.setProperty(CB_PASSWORD, pass != null ? pass.toString() : "");
        cmap.setProperty(CB_REALM, realm != null ? realm.toString() : "");
        cmap.setProperty("serv-name", server != null ? server.toString() : "");
        cmap.setProperty("host", domain != null ? domain.toString() : "");
        cmap.setProperty(CB_AUTHZID, azid != null ? azid.toString() : "");
        cmap.setProperty("response", ClientDigestMD5Mechanism.RESP(cmap));
        if (output == null) {
            output = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_RESPONSE, SASLPacket.class);
            output.setData(MD5MessageCodec.encode(cmap));
            this.setCurrentStatus(AUTHENTICATING_MORE);
        }
        return output;
    }

    private final SASLPacket evaluateNextChallenge(Properties cmap) {
        StreamDataFactory sdf = this.getDataFactory();
        this.setCurrentStatus(AUTHENTICATING_MORE);
        return (SASLPacket)sdf.createPacketNode(SASLPacket.NAME_RESPONSE, SASLPacket.class);
    }

    static {
        TreeMap<String, String> temp = new TreeMap<String, String>();
        temp.put("javax.security.sasl.policy.forward", "false");
        temp.put("javax.security.sasl.policy.noanonymous", "true");
        temp.put("javax.security.sasl.policy.noactive", "true");
        temp.put("javax.security.sasl.policy.nodictionary", "false");
        temp.put("javax.security.sasl.policy.noplaintext", "true");
        temp.put("javax.security.sasl.policy.credentials", "false");
        POLICY = Collections.unmodifiableMap(temp);
    }

    public static class Entry
    extends AbstractMechanismProvider.ClientEntry {
        public Entry() {
            super(ClientDigestMD5Mechanism.NAME, POLICY);
        }

        public SASLMechanism createMechanism(SASLClientInfo info) {
            return new ClientDigestMD5Mechanism(info);
        }
    }

    public static class MD5Status
    extends SASLMechanism.Status {
        private MD5Status(String name, boolean auth, boolean complete) {
            super(name, auth, complete);
        }
    }
}

