/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.AbstractPacket;
import net.outer_planes.jso.AbstractPacketBuilder;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.Utilities;

public class SASLPacketNode
extends AbstractPacket
implements SASLPacket {
    public static final Map SASL_NAMES;
    private SASLPacket.Action _Act;

    public SASLPacketNode(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    protected SASLPacketNode(StreamElement parent, SASLPacketNode base) {
        super(parent, base);
    }

    public StreamBuilder createBuilder() {
        return new AbstractPacketBuilder(this);
    }

    public SASLPacket.Action getAction() {
        if (this._Act == null) {
            this._Act = (SASLPacket.Action)SASL_NAMES.get(this.getNSI());
        }
        return this._Act;
    }

    public byte[] getData() {
        ByteCodec b64 = ByteCodec.BASE64;
        String enc = this.normalizeTrimText();
        return Utilities.isValidString(enc) ? b64.decode(enc) : new byte[]{};
    }

    public void setData(byte[] data) {
        ByteCodec b64 = ByteCodec.BASE64;
        if (data == null) {
            data = new byte[]{};
        }
        this.clearText();
        this.addText(b64.encode(data));
    }

    public PacketError getError() {
        return null;
    }

    public void setError(PacketError err) throws IllegalArgumentException {
    }

    public StreamObject copy(StreamElement parent) {
        return new SASLPacketNode(parent, this);
    }

    static {
        TreeMap<NSI, SASLPacket.Action> temp = new TreeMap<NSI, SASLPacket.Action>(NSI.STRICT_COMPARATOR);
        temp.put(NAME_ABORT, ABORT);
        temp.put(NAME_AUTH, AUTHENTICATE);
        temp.put(NAME_CHALLENGE, CHALLENGE);
        temp.put(NAME_FAILURE, FAILURE);
        temp.put(NAME_RESPONSE, RESPONSE);
        temp.put(NAME_SUCCESS, SUCCESS);
        SASL_NAMES = Collections.unmodifiableMap(temp);
    }
}

