/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.sasl.SASLPacketNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.sasl.SASLFailurePacket;
import org.jabberstudio.jso.util.Utilities;

public class SASLFailurePacketNode
extends SASLPacketNode
implements SASLFailurePacket {
    public static final Map CONDITIONS;

    public SASLFailurePacketNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected SASLFailurePacketNode(StreamElement parent, SASLFailurePacketNode base) {
        super(parent, base);
    }

    public StreamObject copy(StreamElement parent) {
        return new SASLFailurePacketNode(parent, this);
    }

    public String getCondition() {
        StreamElement cond = this.getFirstElement(null, "urn:ietf:params:xml:ns:xmpp-sasl");
        return cond != null ? cond.getLocalName() : "";
    }

    public void setCondition(String cond) throws IllegalArgumentException {
        NSI name = null;
        if (Utilities.isValidString(cond) && (name = (NSI)CONDITIONS.get(cond)) == null) {
            throw new IllegalArgumentException("Condition name is not known");
        }
        this.clearElements();
        if (name != null) {
            this.addElement(name);
        }
    }

    static {
        TreeMap<String, NSI> temp = new TreeMap<String, NSI>();
        temp.put("aborted", new NSI("aborted", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("incorrect-encoding", new NSI("incorrect-encoding", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("invalid-authzid", new NSI("invalid-authzid", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("invalid-mechanism", new NSI("invalid-mechanism", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("mechanism-too-weak", new NSI("mechanism-too-weak", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("not-authorized", new NSI("not-authorized", "urn:ietf:params:xml:ns:xmpp-sasl"));
        temp.put("temporary-auth-failure", new NSI("temporary-auth-failure", "urn:ietf:params:xml:ns:xmpp-sasl"));
        CONDITIONS = Collections.unmodifiableMap(temp);
    }
}

