/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import net.outer_planes.jso.sasl.AbstractMechanism;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLFailedException;
import org.jabberstudio.jso.sasl.SASLFailurePacket;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLPacket;

public abstract class ClientMechanism
extends AbstractMechanism {
    private JID _AuthZid;

    public ClientMechanism(SASLClientInfo ci) {
        super(ci.getDataFactory(), ci.getServer(), ci.getCallbackHandler(), ci.getProperties());
        this._AuthZid = ci.getAuthorizationID();
    }

    public JID getAuthorizationID() {
        return this._AuthZid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SASLPacket evaluate(SASLPacket input) throws IllegalArgumentException, IllegalStateException, SASLFailedException {
        SASLMechanism.Status current = this.getCurrentStatus();
        SASLPacket.Action act = input != null ? input.getAction() : null;
        SASLPacket output = null;
        if (current == READY) {
            if (input == null) {
                return this.generateAuth();
            }
            if (act != SASLPacket.CHALLENGE) throw new IllegalStateException("mechanism is not in a compatible state");
            return this.evaluateChallenge(input);
        }
        if (!current.isAuthenticating()) throw new IllegalStateException("mechanism is already complete");
        if (act != SASLPacket.SUCCESS) {
            if (act == SASLPacket.FAILURE) {
                throw this.completeFailure((SASLFailurePacket)input);
            }
            if (act != SASLPacket.CHALLENGE) throw new IllegalStateException("mechanism is not in a compatible state");
            return this.evaluateChallenge(input);
        }
        this.completeSuccess(input);
        return output;
    }

    protected SASLPacket generateAuth() {
        SASLAuthPacket auth = (SASLAuthPacket)this.getDataFactory().createPacketNode(SASLAuthPacket.NAME, SASLAuthPacket.class);
        auth.setMechanismName(this.getMechanismName());
        return auth;
    }

    protected abstract SASLPacket evaluateChallenge(SASLPacket var1) throws IllegalStateException, SASLFailedException;

    protected void completeSuccess(SASLPacket success) {
        this.setCurrentStatus(SUCCEEDED);
    }

    protected SASLFailedException completeFailure(SASLFailurePacket failed) {
        this.setCurrentStatus(FAILED);
        return new SASLFailedException(failed);
    }
}

