/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.ixp;

import com.jclark.xml.tok.ContentToken;
import com.jclark.xml.tok.EmptyTokenException;
import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.ExtensibleTokenException;
import com.jclark.xml.tok.PartialTokenException;
import com.jclark.xml.tok.StringConversionCache;
import com.jclark.xml.tok.Token;
import com.jclark.xml.tok.TokenException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.ixp.Buffer;
import net.outer_planes.jso.ixp.Context;
import net.outer_planes.jso.ixp.InvalidXMLException;
import net.outer_planes.jso.ixp.IxpException;
import net.outer_planes.jso.ixp.NamespaceManager;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.Utilities;

public class IxpParser {
    private Buffer _Buffer;
    private Context _Ctx;

    public IxpParser(StreamElement ctx, StreamSource src) {
        this._Buffer = new Buffer(src);
        this._Ctx = new Context(ctx);
    }

    private Encoding findEncoding() {
        Context ctx = this.getContext();
        Buffer buffer = this.getBuffer();
        byte[] data = buffer.getData();
        int len = buffer.getLength();
        Token token = new Token();
        Encoding enc = Encoding.getInitialEncoding((byte[])data, (int)0, (int)len, (Token)token);
        buffer.eat(token.getTokenEnd());
        ctx.configureEncoding(enc);
        return enc;
    }

    private Buffer getBuffer() {
        return this._Buffer;
    }

    private Context getContext() {
        return this._Ctx;
    }

    public boolean isEOD() {
        return this.getContext().isEOD();
    }

    public StreamParseState process() throws IOException, IxpException {
        Context ctx = this.getContext();
        Buffer buffer = this.getBuffer();
        ContentToken ct = new ContentToken();
        boolean cont = true;
        boolean more = false;
        while (!ctx.hasStates() && cont) {
            byte[] data = buffer.getData();
            int length = buffer.getLength();
            boolean bl = more ? true : (more = length == 0);
            if (more) {
                buffer.fill();
                data = buffer.getData();
                length = buffer.getLength();
            }
            try {
                int type = this.tokenize(ct);
                length = ct.getTokenEnd();
                more = length == 0;
                switch (type) {
                    case 14: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.handleElementStart(ct, data, false);
                        break;
                    }
                    case 6: {
                        this.handleElementEnd(ct, data, false);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.handleElementStart(ct, data, true);
                        this.handleElementEnd(ct, data, true);
                        break;
                    }
                    case 7: {
                        ctx.startCDATA();
                        break;
                    }
                    case 8: {
                        ctx.endCDATA();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 9: {
                        ctx.characters(ctx.getStringConverter().convert(data, 0, length, false));
                        break;
                    }
                    case 10: 
                    case 11: {
                        ctx.characters(Character.toString(ct.getRefChar()));
                        break;
                    }
                }
                buffer.eat(length);
            }
            catch (PartialTokenException pte) {
                this.checkBuffer((Exception)((Object)pte));
                if (more) {
                    cont = false;
                    continue;
                }
                cont = true;
                more = true;
            }
            catch (ExtensibleTokenException xte) {
                this.checkBuffer((Exception)((Object)xte));
                if (more) {
                    cont = false;
                    continue;
                }
                cont = true;
                more = true;
            }
            catch (EmptyTokenException ete) {
                this.checkBuffer((Exception)((Object)ete));
                if (more) {
                    cont = false;
                    continue;
                }
                cont = true;
                more = true;
            }
            catch (TokenException te) {
                InvalidXMLException ixp = new InvalidXMLException(te.getMessage());
                ixp.initCause(te);
                throw ixp;
            }
        }
        return ctx.popState();
    }

    private int tokenize(ContentToken ct) throws TokenException {
        Context ctx = this.getContext();
        Buffer buffer = this.getBuffer();
        Encoding enc = ctx.getEncoding();
        byte[] data = buffer.getData();
        int len = buffer.getLength();
        if (enc == null) {
            enc = this.findEncoding();
            data = buffer.getData();
            len = buffer.getLength();
        }
        int type = ctx.isInCData() ? enc.tokenizeCdataSection(data, 0, len, (Token)ct) : enc.tokenizeContent(data, 0, len, ct);
        return type;
    }

    private void handleElementStart(ContentToken ct, byte[] data, boolean empty) throws IxpException {
        String uri;
        String lname;
        String prefix;
        String value;
        String qname;
        Map.Entry entry;
        Context ctx = this.getContext();
        Encoding enc = ctx.getEncoding();
        StringConversionCache scc = ctx.getStringConverter();
        HashMap props = new HashMap();
        TreeMap<NSI, String> attrs = new TreeMap<NSI, String>(NSI.STRICT_COMPARATOR);
        HashMap<String, String> nss = new HashMap<String, String>();
        int start = enc.getMinBytesPerChar();
        int end = ct.getNameEnd();
        this.buildAttributes(ct, data, props);
        Iterator itr = props.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            qname = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!qname.startsWith("xmlns")) continue;
            prefix = this.findLocalName(qname);
            if (prefix.equals("xmlns")) {
                prefix = "";
            }
            nss.put(prefix, value);
            itr.remove();
        }
        NamespaceManager nsm = ctx.pushNamespaces(nss);
        itr = props.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            value = (String)entry.getValue();
            qname = (String)entry.getKey();
            prefix = this.findPrefix(qname);
            lname = this.findLocalName(qname);
            uri = Utilities.isValidString(prefix) ? nsm.getNamespaceURI(prefix) : null;
            attrs.put(new NSI(lname, uri), value);
        }
        qname = scc.convert(data, start, end, false);
        prefix = this.findPrefix(qname);
        lname = this.findLocalName(qname);
        uri = nsm.getNamespaceURI(prefix);
        ctx.startElement(new NSI(lname, uri), nss, attrs);
    }

    private void handleElementEnd(ContentToken ct, byte[] data, boolean empty) throws IxpException {
        Context ctx = this.getContext();
        Encoding enc = ctx.getEncoding();
        StringConversionCache scc = ctx.getStringConverter();
        NamespaceManager nsm = ctx.getNamespaces();
        int start = empty ? enc.getMinBytesPerChar() : enc.getMinBytesPerChar() * 2;
        int end = ct.getNameEnd();
        String qname = scc.convert(data, start, end, false);
        String prefix = this.findPrefix(qname);
        String lname = this.findLocalName(qname);
        String uri = nsm.getNamespaceURI(prefix);
        ctx.endElement(new NSI(lname, uri));
    }

    private String findPrefix(String qname) {
        int pos = qname.indexOf(58);
        String prefix = pos != -1 ? qname.substring(0, pos) : "";
        return prefix;
    }

    private String findLocalName(String qname) {
        int pos = qname.indexOf(58);
        String ln = pos != -1 ? qname.substring(pos + 1) : qname;
        return ln;
    }

    private void buildAttributes(ContentToken ct, byte[] data, Map attrs) throws IxpException {
        StringConversionCache scc = this.getContext().getStringConverter();
        int idx = ct.getAttributeSpecifiedCount();
        while (idx-- > 0) {
            int start = ct.getAttributeNameStart(idx);
            int end = ct.getAttributeNameEnd(idx);
            String name = scc.convert(data, start, end, false);
            start = ct.getAttributeValueStart(idx);
            end = ct.getAttributeValueEnd(idx);
            String value = this.formatAttributeValue(data, start, end);
            attrs.put(name, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String formatAttributeValue(byte[] data, int start, int end) throws IxpException {
        Encoding enc = this.getContext().getEncoding();
        StringConversionCache scc = this.getContext().getStringConverter();
        Token token = new Token();
        StringBuffer sb = new StringBuffer();
        while (start < end) {
            void var8_8;
            void var9_9;
            int next;
            int type;
            try {
                type = enc.tokenizeAttributeValue(data, start, end, token);
                next = token.getTokenEnd();
            }
            catch (ExtensibleTokenException ete) {
                type = ete.getTokenType();
                next = token.getTokenEnd();
            }
            catch (TokenException te) {
                InvalidXMLException ixp = new InvalidXMLException(te.getMessage());
                ixp.initCause(te);
                throw ixp;
            }
            switch (var9_9) {
                case 0: 
                case 1: 
                case 16: {
                    sb.append(scc.convert(data, start, (int)var8_8, false));
                    break;
                }
                case 10: 
                case 11: {
                    sb.append(token.getRefChar());
                }
            }
            start = var8_8;
        }
        return sb.toString();
    }

    private void checkBuffer(Exception e) throws IxpException {
        Buffer buffer = this.getBuffer();
        Context ctx = this.getContext();
        if (buffer.isEOF()) {
            if (ctx.isEOD()) {
                InvalidXMLException ixp = new InvalidXMLException(e.getMessage());
                ixp.initCause(e);
                throw ixp;
            }
            ctx.setEOD(true);
        }
    }
}

