/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;

public class XMLParseState
implements StreamParseState {
    private XMLParseState _Parent;
    private List _Nodes = new LinkedList();
    private StreamParseState.Type _Type;
    private StreamElement _Ctx;
    private NSI _Name;
    private Map _Nss = new TreeMap();
    private Map _Attrs = new TreeMap(NSI.NS_LOOSE_COMPARATOR);
    private String _Text;

    public XMLParseState(StreamElement ctx, XMLParseState parent, StreamParseState.Type type) {
        this._Parent = parent;
        this._Ctx = ctx;
        this._Type = type;
    }

    public static XMLParseState createForElementStart(StreamElement ctx, XMLParseState p, NSI name, Map nss, Map attrs) {
        XMLParseState sps = new XMLParseState(ctx, p, ELEMENT_START);
        sps.setName(name);
        sps.setNamespaces(nss);
        sps.setAttributes(attrs);
        return sps;
    }

    public static XMLParseState createForElementEnd(StreamElement ctx, XMLParseState p, NSI name) {
        XMLParseState sps = new XMLParseState(ctx, p, ELEMENT_START);
        sps.setName(name);
        return sps;
    }

    public static XMLParseState createForText(StreamElement ctx, XMLParseState p, String txt) {
        XMLParseState sps = new XMLParseState(ctx, p, TEXT);
        sps.setText(txt);
        return sps;
    }

    public XMLParseState getParent() {
        return this._Parent;
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    public StreamParseState.Type getType() {
        return this._Type;
    }

    public int getDepth() {
        XMLParseState parent = this.getParent();
        return (parent != null ? parent.getDepth() : 0) + 1;
    }

    public NSI getName() {
        return this._Name;
    }

    private void setName(NSI name) {
        this._Name = name;
    }

    public Map getNamespaces() {
        return this._Nss;
    }

    private void setNamespaces(Map nss) {
        this._Nss.clear();
        if (nss != null) {
            this._Nss.putAll(nss);
        }
    }

    public Set getNamespaceURIs(int depth) {
        if (depth < this.getDepth() && this.getParent() != null) {
            return this.getParent().getNamespaceURIs(depth);
        }
        return new TreeSet(this.getNamespaces().values());
    }

    public Set getNamespacePrefixes(int depth) {
        if (depth < this.getDepth() && this.getParent() != null) {
            return this.getParent().getNamespacePrefixes(depth);
        }
        return this.getNamespaces().keySet();
    }

    public String getNamespacePrefix(String uri) {
        String prefix = null;
        Iterator itr = this.getNamespaces().values().iterator();
        if (uri == null) {
            uri = "";
        }
        while (prefix == null && itr.hasNext()) {
            String temp = (String)itr.next();
            if (!temp.equals(uri)) continue;
            prefix = temp;
        }
        if (prefix == null && this.getParent() != null) {
            prefix = this.getParent().getNamespacePrefix(uri);
        }
        return prefix;
    }

    public String getNamespaceURI(String prefix) {
        String uri;
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = (String)this.getNamespaces().get(prefix)) == null && this.getParent() != null) {
            uri = this.getParent().getNamespaceURI(prefix);
        }
        return uri;
    }

    public Map getAttributes() {
        return this._Attrs;
    }

    private void setAttributes(Map attrs) {
        this._Attrs.clear();
        if (attrs != null) {
            this._Attrs.putAll(attrs);
        }
    }

    public Set getAttributeNames() {
        return this.getAttributes().keySet();
    }

    public String getAttributeValue(String name) throws IllegalArgumentException {
        return this.getAttributeValue(new NSI(name, null));
    }

    public String getAttributeValue(NSI name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Local Name cannot be null or \"\"");
        }
        return (String)this.getAttributes().get(name);
    }

    public String getText() {
        return this._Text;
    }

    private void setText(String txt) {
        this._Text = txt != null ? txt : "";
    }

    public String getXML() {
        return "";
    }
}

