/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMParseState
implements StreamParseState {
    private DOMParseState _Parent;
    private Node _Node;
    private List _Nodes = new LinkedList();
    private StreamParseState.Type _Type;
    private StreamElement _Ctx;
    private NSI _Name;
    private Map _Nss = new TreeMap();
    private Map _Attrs = new TreeMap(NSI.NS_LOOSE_COMPARATOR);
    private String _Text;

    protected DOMParseState(StreamElement ctx, DOMParseState p, Node n) {
        this._Ctx = ctx;
        this._Parent = p;
        this._Node = n;
    }

    public static DOMParseState createForElement(StreamElement ctx, DOMParseState parent, Element e) {
        DOMParseState state = new DOMParseState(ctx, parent, e);
        String ln = DOMParseState.getLocalName(e.getNodeName());
        String prefix = DOMParseState.getPrefix(e.getNodeName());
        String uri = DOMParseState.findNamespaceURI(e, state, ctx);
        NamedNodeMap attrs = e.getAttributes();
        for (int idx = 0; idx < attrs.getLength(); ++idx) {
            Attr attr = (Attr)attrs.item(idx);
            String attrQN = attr.getName();
            String attrLN = DOMParseState.getLocalName(attrQN);
            String attrPre = DOMParseState.getPrefix(attrQN);
            String attrURI = attr.getNamespaceURI();
            String attrVal = attr.getValue();
            if (attrQN.equals("xmlns")) {
                state.addNamespace(attrVal, "");
                uri = attrVal;
                continue;
            }
            if (attrQN.startsWith("xmlns:")) {
                state.addNamespace(attrVal, attrLN);
                if (!attrLN.equals(prefix)) continue;
                uri = attrVal;
                continue;
            }
            state.setAttributeValue(attrLN, attrURI, attrVal);
        }
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) && !(child instanceof Text)) continue;
            state.addNode(child);
        }
        state.setName(ln, uri);
        return state;
    }

    public static DOMParseState createForText(StreamElement ctx, DOMParseState parent, Text t) {
        DOMParseState state = new DOMParseState(ctx, parent, t);
        state.setText(t.getNodeValue());
        state.setType(TEXT);
        return state;
    }

    private static String getLocalName(String qname) {
        int pos = qname.indexOf(":");
        String local = pos != -1 ? qname.substring(pos + 1) : qname;
        return local;
    }

    private static String getPrefix(String qname) {
        int pos = qname.indexOf(":");
        String prefix = pos != -1 ? qname.substring(0, pos) : null;
        return prefix;
    }

    private static String findNamespaceURI(Element e, DOMParseState parent, StreamElement ctx) {
        String uri = e.getNamespaceURI();
        String prefix = DOMParseState.getPrefix(e.getNodeName());
        if (uri == null && parent != null) {
            uri = parent.getNamespaceURI(prefix);
        }
        if (uri == null && ctx != null) {
            uri = ctx.getNamespaceURI(prefix);
        }
        return uri;
    }

    public DOMParseState getParent() {
        return this._Parent;
    }

    public StreamParseState.Type getType() {
        return this._Type;
    }

    public void setType(StreamParseState.Type t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this._Type = t;
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    public int getDepth() {
        return this.getParent() != null ? this.getParent().getDepth() + 1 : 1;
    }

    public String getXML() {
        return this._Node.toString();
    }

    public NSI getName() {
        return this._Name;
    }

    private void setName(NSI name) {
        this._Name = name;
    }

    private void setName(String localname, String uri) {
        this.setName(new NSI(localname, uri));
    }

    protected Map getNamespaces() {
        return this._Nss;
    }

    private void addNamespace(String uri, String prefix) {
        if (uri == null) {
            uri = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        this._Nss.put(prefix, uri);
    }

    public Set getNamespaceURIs(int depth) {
        if (depth < this.getDepth() && this.getParent() != null) {
            return this.getParent().getNamespaceURIs(depth);
        }
        return new TreeSet(this.getNamespaces().values());
    }

    public Set getNamespacePrefixes(int depth) {
        if (depth < this.getDepth() && this.getParent() != null) {
            return this.getParent().getNamespacePrefixes(depth);
        }
        return this.getNamespaces().keySet();
    }

    public String getNamespacePrefix(String uri) {
        String prefix = null;
        Iterator itr = this.getNamespaces().values().iterator();
        if (uri == null) {
            uri = "";
        }
        while (prefix == null && itr.hasNext()) {
            String temp = (String)itr.next();
            if (!temp.equals(uri)) continue;
            prefix = temp;
        }
        if (prefix == null && this.getParent() != null) {
            prefix = this.getParent().getNamespacePrefix(uri);
        }
        return prefix;
    }

    public String getNamespaceURI(String prefix) {
        String uri;
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = (String)this.getNamespaces().get(prefix)) == null && this.getParent() != null) {
            uri = this.getParent().getNamespaceURI(prefix);
        }
        return uri;
    }

    protected Map getAttributes() {
        return this._Attrs;
    }

    public Set getAttributeNames() {
        return this.getAttributes().keySet();
    }

    public String getAttributeValue(String name) throws IllegalArgumentException {
        return this.getAttributeValue(new NSI(name, null));
    }

    public String getAttributeValue(NSI name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Local Name cannot be null or \"\"");
        }
        return (String)this.getAttributes().get(name);
    }

    private void setAttributeValue(String name, String value) throws IllegalArgumentException {
        this.setAttributeValue(new NSI(name, null), value);
    }

    private void setAttributeValue(String name, String uri, String value) throws IllegalArgumentException {
        this.setAttributeValue(new NSI(name, uri), value);
    }

    private void setAttributeValue(NSI name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Local Name cannot be null or \"\"");
        }
        if (!this.getAttributes().containsKey(name) && name.getNamespaceURI() == null) {
            name = new NSI(name.getLocalName(), "");
        }
        if (value == null) {
            this.getAttributes().remove(name);
        } else {
            this.getAttributes().put(name, value);
        }
    }

    public List getNodes() {
        return this._Nodes;
    }

    private void addNode(Node n) {
        this._Nodes.add(n);
    }

    public String getText() {
        return this._Text;
    }

    private void setText(String text) {
        this._Text = text;
    }
}

