/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.AbstractPacket;
import net.outer_planes.jso.AbstractPacketBuilder;
import org.jabberstudio.jso.ErrorCondition;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class StreamErrorNode
extends AbstractPacket
implements StreamError {
    public static final NSI ELEMNAME_TEXT = new NSI("text", "urn:ietf:params:xml:ns:xmpp-streams");
    public static final NSI NAME = new NSI("error", "http://etherx.jabber.org/streams");
    public static final Map DEFINED_CONDITIONS;
    private XPath _AppCondPath;

    public StreamErrorNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected StreamErrorNode(StreamElement parent, StreamErrorNode base) {
        super(parent, base);
    }

    protected XPath getApplicationConditionXPath() {
        if (this._AppCondPath == null) {
            if (this._AppCondPath == null) {
                try {
                    this._AppCondPath = this.getDataFactory().createXPath("*[namespace-uri()!='" + this.getNamespaceURI() + "' and namespace-uri()!='" + "urn:ietf:params:xml:ns:xmpp-streams" + "']");
                }
                catch (SAXPathException sAXPathException) {
                    // empty catch block
                }
            }
            return this._AppCondPath;
        }
        return this._AppCondPath;
    }

    public StreamBuilder createBuilder() {
        return new AbstractPacketBuilder(this){

            protected StreamBuilder.Status processNestedElementStart(StreamParseState s) {
                StreamElement ctx = s.getContext();
                NSI.Comparator cmpr = NSI.NS_LOOSE_COMPARATOR;
                NSI name = s.getName();
                String uri = name.getNamespaceURI();
                String ln = name.getLocalName();
                StreamDataFactory sdf = ctx.getDataFactory();
                if (Utilities.equateStrings("urn:ietf:params:xml:ns:xmpp-streams", uri) && Utilities.equateStrings("text", ln)) {
                    this.setExtendedData(sdf.createElementBuilder(name));
                } else {
                    this.setExtendedData(sdf.createElementBuilder(name, class$org$jabberstudio$jso$ErrorCondition == null ? (class$org$jabberstudio$jso$ErrorCondition = StreamErrorNode.class$("org.jabberstudio.jso.ErrorCondition")) : class$org$jabberstudio$jso$ErrorCondition));
                }
                return EXTENDED_DATA;
            }

            public StreamNode getNode() throws IllegalStateException {
                StreamError err = (StreamError)super.getNode();
                String txt = err.normalizeText();
                String cond = err.getDefinedCondition();
                if (!Utilities.isValidString(cond)) {
                    err.setDefinedCondition("undefined-condition");
                }
                if (Utilities.isValidString(txt)) {
                    err.clearText();
                    err.setText(txt);
                }
                return err;
            }
        };
    }

    public PacketError getError() {
        return null;
    }

    public void setError(PacketError err) throws IllegalArgumentException {
    }

    public String getText() {
        StreamElement text = this.getFirstElement("text", "urn:ietf:params:xml:ns:xmpp-streams");
        return text != null ? text.normalizeTrimText() : "";
    }

    public void setText(String txt) {
        Iterator itr = this.listElements(ELEMNAME_TEXT).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (txt != null) {
            this.addElement(ELEMNAME_TEXT).addText(txt);
        }
    }

    public List listConditions() {
        return this.listElements(ErrorCondition.class);
    }

    public NSI getApplicationCondition() {
        NSI name = null;
        try {
            StreamElement elem = (StreamElement)this.getApplicationConditionXPath().selectSingleNode((Object)this);
            if (elem != null) {
                name = elem.getNSI();
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return name;
    }

    public void setApplicationCondition(NSI name) {
        if (name != null) {
            if (!Utilities.isValidString(name.getLocalName())) {
                throw new IllegalArgumentException("localname cannot be null or \"\"");
            }
            if (Utilities.equateStrings(name.getNamespaceURI(), this.getNSI().getNamespaceURI())) {
                throw new IllegalArgumentException("namespace URI cannot be in stanza namespace");
            }
            if (Utilities.equateStrings(name.getNamespaceURI(), "urn:ietf:params:xml:ns:xmpp-streams")) {
                throw new IllegalArgumentException("namespace URI cannot be in stanza-conditions namespace");
            }
        }
        try {
            Iterator itr = this.getApplicationConditionXPath().selectNodes((Object)this).iterator();
            while (itr.hasNext()) {
                ((StreamElement)itr.next()).detach();
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        if (name != null) {
            this.addElement(name, ErrorCondition.class);
        }
    }

    public String getDefinedCondition() {
        StreamElement condition = this.getFirstElement(null, "urn:ietf:params:xml:ns:xmpp-streams", ErrorCondition.class);
        String name = "";
        if (condition != null) {
            name = condition.getLocalName();
        }
        return name;
    }

    public void setDefinedCondition(String name) throws IllegalArgumentException {
        Iterator itr = this.listElements(null, "urn:ietf:params:xml:ns:xmpp-streams", ErrorCondition.class).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (Utilities.isValidString(name)) {
            NSI nsi = (NSI)DEFINED_CONDITIONS.get(name);
            if (nsi == null) {
                throw new IllegalArgumentException("\"" + nsi + "\" is not a defined condition");
            }
            this.addElement(nsi, ErrorCondition.class);
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new StreamErrorNode(parent, this);
    }

    static {
        TreeMap<String, NSI> temp = new TreeMap<String, NSI>();
        NSI name = new NSI("bad-format", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("bad-namespace-prefix", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("conflict", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("connection-timeout", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("host-gone", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("host-unknown", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("improper-addressing", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("internal-server-error", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("invalid-from", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("invalid-id", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("invalid-xml", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("not-authorized", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("policy-violation", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("remote-connection-failed", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("resource-constraint", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("restricted-xml", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("see-other-host", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("system-shutdown", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("undefined-condition", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("unsupported-encoding", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("unsupported-stanza-type", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("unsupported-version", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        name = new NSI("xml-not-well-fomred", "urn:ietf:params:xml:ns:xmpp-streams");
        temp.put(name.getLocalName(), name);
        DEFINED_CONDITIONS = Collections.unmodifiableMap(temp);
    }
}

